/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.canal;

import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.MetadataUtil;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class CanalJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "Canal";
    private static final String FIELD_OLD = "old";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DATABASE = "database";
    private static final String FIELD_TABLE = "table";
    private static final String FIELD_TS = "ts";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_DELETE = "DELETE";
    private static final String OP_CREATE = "CREATE";
    private static final String OP_QUERY = "QUERY";
    private static final String OP_ALTER = "ALTER";
    private final String database;
    private final String table;
    private final String[] fieldNames;
    private final int fieldCount;
    private final boolean ignoreParseErrors;
    private final Pattern databasePattern;
    private final Pattern tablePattern;
    private final JsonDeserializationSchema jsonDeserializer;
    private final SeaTunnelRowType seaTunnelRowType;
    private final CatalogTable catalogTable;

    public CanalJsonDeserializationSchema(@NonNull CatalogTable catalogTable, String database, String table, boolean ignoreParseErrors) {
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.catalogTable = catalogTable;
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        this.jsonDeserializer = new JsonDeserializationSchema(catalogTable, false, ignoreParseErrors);
        this.database = database;
        this.table = table;
        this.fieldNames = this.seaTunnelRowType.getFieldNames();
        this.fieldCount = this.seaTunnelRowType.getTotalFields();
        this.ignoreParseErrors = ignoreParseErrors;
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    public void deserialize(ObjectNode jsonNode, Collector<SeaTunnelRow> out) throws IOException {
        block27: {
            TablePath tablePath = Optional.ofNullable(this.catalogTable).map(CatalogTable::getTablePath).orElse(null);
            try {
                if (this.database != null && !this.databasePattern.matcher(jsonNode.get(FIELD_DATABASE).asText()).matches()) {
                    return;
                }
                if (this.table != null && !this.tablePattern.matcher(jsonNode.get(FIELD_TABLE).asText()).matches()) {
                    return;
                }
                JsonNode dataNode = jsonNode.get(FIELD_DATA);
                String op = jsonNode.get(FIELD_TYPE).asText();
                JsonNode tsNode = jsonNode.get(FIELD_TS);
                if (dataNode == null || dataNode.isNull()) {
                    if (OP_QUERY.equals(op) || OP_CREATE.equals(op) || OP_ALTER.equals(op)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Null data value '%s' Cannot send downstream", jsonNode));
                }
                switch (op) {
                    case "INSERT": {
                        for (int i = 0; i < dataNode.size(); ++i) {
                            SeaTunnelRow row = this.convertJsonNode(dataNode.get(i));
                            if (tablePath != null && !tablePath.toString().isEmpty()) {
                                row.setTableId(tablePath.toString());
                            }
                            if (tsNode != null) {
                                MetadataUtil.setEventTime((SeaTunnelRow)row, (Long)tsNode.asLong());
                            }
                            out.collect((Object)row);
                        }
                        break;
                    }
                    case "UPDATE": {
                        ArrayNode oldNode = (ArrayNode)jsonNode.get(FIELD_OLD);
                        for (int i = 0; i < dataNode.size(); ++i) {
                            SeaTunnelRow after = this.convertJsonNode(dataNode.get(i));
                            SeaTunnelRow before = this.convertJsonNode(oldNode.get(i));
                            for (int f = 0; f < this.fieldCount; ++f) {
                                if (!before.isNullAt(f) || oldNode.findValue(this.fieldNames[f]) != null) continue;
                                before.setField(f, after.getField(f));
                            }
                            before.setRowKind(RowKind.UPDATE_BEFORE);
                            if (tablePath != null && !tablePath.toString().isEmpty()) {
                                before.setTableId(tablePath.toString());
                            }
                            after.setRowKind(RowKind.UPDATE_AFTER);
                            if (tablePath != null && !tablePath.toString().isEmpty()) {
                                after.setTableId(tablePath.toString());
                            }
                            if (tsNode != null) {
                                MetadataUtil.setEventTime((SeaTunnelRow)before, (Long)tsNode.asLong());
                                MetadataUtil.setEventTime((SeaTunnelRow)after, (Long)tsNode.asLong());
                            }
                            out.collect((Object)before);
                            out.collect((Object)after);
                        }
                        break;
                    }
                    case "DELETE": {
                        for (int i = 0; i < dataNode.size(); ++i) {
                            SeaTunnelRow row = this.convertJsonNode(dataNode.get(i));
                            row.setRowKind(RowKind.DELETE);
                            if (tablePath != null && !tablePath.toString().isEmpty()) {
                                row.setTableId(tablePath.toString());
                            }
                            if (tsNode != null) {
                                MetadataUtil.setEventTime((SeaTunnelRow)row, (Long)tsNode.asLong());
                            }
                            out.collect((Object)row);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block27;
                throw CommonError.jsonOperationError((String)FORMAT, (String)jsonNode.toString(), (Throwable)e);
            }
        }
    }

    private ObjectNode convertBytes(byte[] message) throws SeaTunnelRuntimeException {
        if (message == null || message.length == 0) {
            return null;
        }
        try {
            return (ObjectNode)this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (Throwable t) {
            if (!this.ignoreParseErrors) {
                throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
            }
            return null;
        }
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) throws IOException {
        ObjectNode jsonNodes = this.convertBytes(message);
        if (jsonNodes != null) {
            this.deserialize(this.convertBytes(message), out);
        }
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.jsonDeserializer.convertToRowData(root);
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType physicalDataType) {
        return physicalDataType;
    }

    public static Builder builder(CatalogTable catalogTable) {
        return new Builder(catalogTable);
    }

    public static class Builder {
        private boolean ignoreParseErrors = false;
        private String database = null;
        private String table = null;
        private CatalogTable catalogTable;

        public Builder(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public Builder setCatalogTable(CatalogTable catalogTable) {
            this.catalogTable = catalogTable;
            return this;
        }

        public CanalJsonDeserializationSchema build() {
            return new CanalJsonDeserializationSchema(this.catalogTable, this.database, this.table, this.ignoreParseErrors);
        }
    }
}

