/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.oss.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.oss.config.OssFileSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.oss.source.OssFileSource;

@AutoService(value={Factory.class})
public class OssFileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.OSS.getFileSystemPluginName();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new OssFileSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().exclusive(new Option[]{OssFileSourceOptions.TABLE_CONFIGS, FileBaseOptions.FILE_PATH}).optional(new Option[]{OssFileSourceOptions.BUCKET}).optional(new Option[]{OssFileSourceOptions.ACCESS_KEY}).optional(new Option[]{OssFileSourceOptions.ACCESS_SECRET}).optional(new Option[]{OssFileSourceOptions.ENDPOINT}).optional(new Option[]{FileBaseSourceOptions.FILE_FORMAT_TYPE}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{FileBaseSourceOptions.ROW_DELIMITER, FileBaseSourceOptions.FIELD_DELIMITER, FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.XML, new Option[]{FileBaseSourceOptions.XML_ROW_TAG, FileBaseSourceOptions.XML_USE_ATTR_FORMAT}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, (Object)FileFormat.CSV, new Option[]{FileBaseSourceOptions.SKIP_HEADER_ROW_NUMBER}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.EXCEL, FileFormat.CSV, FileFormat.XML), new Option[]{ConnectorCommonOptions.SCHEMA}).conditional(FileBaseSourceOptions.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON, FileFormat.CSV, FileFormat.XML), new Option[]{FileBaseSourceOptions.ENCODING}).optional(new Option[]{FileBaseSourceOptions.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{FileBaseSourceOptions.DATE_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.DATETIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.TIME_FORMAT_LEGACY}).optional(new Option[]{FileBaseSourceOptions.FILE_FILTER_PATTERN}).optional(new Option[]{FileBaseSourceOptions.COMPRESS_CODEC}).optional(new Option[]{FileBaseSourceOptions.ARCHIVE_COMPRESS_CODEC}).optional(new Option[]{FileBaseSourceOptions.NULL_FORMAT}).optional(new Option[]{FileBaseSourceOptions.FILENAME_EXTENSION}).optional(new Option[]{FileBaseSourceOptions.READ_COLUMNS}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return OssFileSource.class;
    }
}

