/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util.H1SeekableInputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util.HadoopPositionOutputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.ParquetDecodingException;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.PositionOutputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);
    private static final Class<?> byteBufferReadableClass = HadoopStreams.getReadableClass();
    static final Constructor<SeekableInputStream> h2SeekableConstructor = HadoopStreams.getH2SeekableConstructor();

    public static SeekableInputStream wrap(FSDataInputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null input stream");
        if (byteBufferReadableClass != null && h2SeekableConstructor != null && byteBufferReadableClass.isInstance(stream.getWrappedStream())) {
            try {
                return h2SeekableConstructor.newInstance(stream);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.warn("Could not instantiate H2SeekableInputStream, falling back to byte array reads", (Throwable)e);
                return new H1SeekableInputStream(stream);
            }
            catch (InvocationTargetException e) {
                throw new ParquetDecodingException("Could not instantiate H2SeekableInputStream", e.getTargetException());
            }
        }
        return new H1SeekableInputStream(stream);
    }

    private static Class<?> getReadableClass() {
        try {
            return Class.forName("org.apache.hadoop.fs.ByteBufferReadable");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static Class<SeekableInputStream> getH2SeekableClass() {
        try {
            return Class.forName("org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util.H2SeekableInputStream");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static Constructor<SeekableInputStream> getH2SeekableConstructor() {
        Class<SeekableInputStream> h2SeekableClass = HadoopStreams.getH2SeekableClass();
        if (h2SeekableClass != null) {
            try {
                return h2SeekableClass.getConstructor(FSDataInputStream.class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    public static PositionOutputStream wrap(FSDataOutputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null output stream");
        return new HadoopPositionOutputStream(stream);
    }
}

