/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.split;

import java.util.Objects;
import org.apache.seatunnel.api.source.SourceSplit;

public class FileSourceSplit
implements SourceSplit {
    private static final long serialVersionUID = 1L;
    private final String tableId;
    private final String filePath;

    public FileSourceSplit(String splitId) {
        this.filePath = splitId;
        this.tableId = null;
    }

    public FileSourceSplit(String tableId, String filePath) {
        this.tableId = tableId;
        this.filePath = filePath;
    }

    public String splitId() {
        if (this.tableId == null) {
            return this.filePath;
        }
        return this.tableId + "_" + this.filePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSourceSplit that = (FileSourceSplit)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.filePath);
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

