/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import io.airlift.compress.lzo.LzopCodec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.CompressFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileBaseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(JsonReadStrategy.class);
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private CompressFormat compressFormat = (CompressFormat)FileBaseSourceOptions.COMPRESS_CODEC.defaultValue();
    private String encoding = (String)FileBaseSourceOptions.ENCODING.defaultValue();

    @Override
    public void init(HadoopConf conf) {
        super.init(conf);
        if (this.pluginConfig.hasPath(FileBaseSourceOptions.COMPRESS_CODEC.key())) {
            String compressCodec = this.pluginConfig.getString(FileBaseSourceOptions.COMPRESS_CODEC.key());
            this.compressFormat = CompressFormat.valueOf(compressCodec.toUpperCase());
        }
        this.encoding = ReadonlyConfig.fromConfig((Config)this.pluginConfig).getOptional(FileBaseSourceOptions.ENCODING).orElse(StandardCharsets.UTF_8.name());
    }

    @Override
    public void setCatalogTable(CatalogTable catalogTable) {
        super.setCatalogTable(catalogTable);
        this.deserializationSchema = this.isMergePartition ? new JsonDeserializationSchema(false, false, this.seaTunnelRowTypeWithPartition) : new JsonDeserializationSchema(false, false, this.seaTunnelRowType);
    }

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        this.resolveArchiveCompressedInputStream(path, tableId, output, partitionsMap, FileFormat.JSON);
    }

    @Override
    public void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        InputStream actualInputStream;
        switch (this.compressFormat) {
            case LZO: {
                LzopCodec lzo = new LzopCodec();
                actualInputStream = lzo.createInputStream(inputStream);
                break;
            }
            case NONE: {
                actualInputStream = inputStream;
                break;
            }
            default: {
                log.warn("Json file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                actualInputStream = inputStream;
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(actualInputStream, this.encoding));){
            reader.lines().forEach(line -> {
                try {
                    SeaTunnelRow seaTunnelRow = (SeaTunnelRow)this.deserializationSchema.deserialize(line.getBytes(StandardCharsets.UTF_8));
                    if (this.isMergePartition) {
                        int index = this.seaTunnelRowType.getTotalFields();
                        for (String value : partitionsMap.values()) {
                            seaTunnelRow.setField(index++, (Object)value);
                        }
                    }
                    seaTunnelRow.setTableId(tableId);
                    output.collect((Object)seaTunnelRow);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Deserialize this jsonFile data [%s] failed, please check the origin data", line);
                    throw new FileConnectorException(FileConnectorErrorCode.DATA_DESERIALIZE_FAILED, errorMsg, e);
                }
            });
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) throws FileConnectorException {
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "User must defined schema for json file type");
    }
}

