/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.List;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.EncodingUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlWriter {
    private final FileSinkConfig fileSinkConfig;
    private final List<Integer> sinkColumnsIndexInRow;
    private final SeaTunnelRowType seaTunnelRowType;
    private final Document document;
    private final Element rootElement;
    private final String fieldDelimiter;
    private OutputFormat format;

    public XmlWriter(FileSinkConfig fileSinkConfig, List<Integer> sinkColumnsIndexInRow, SeaTunnelRowType seaTunnelRowType) {
        this.fileSinkConfig = fileSinkConfig;
        this.sinkColumnsIndexInRow = sinkColumnsIndexInRow;
        this.seaTunnelRowType = seaTunnelRowType;
        this.fieldDelimiter = fileSinkConfig.getFieldDelimiter();
        this.setXmlOutputFormat();
        this.document = DocumentHelper.createDocument();
        this.rootElement = this.document.addElement(fileSinkConfig.getXmlRootTag());
    }

    public void writeData(SeaTunnelRow seaTunnelRow) {
        Element rowElement = this.rootElement.addElement(this.fileSinkConfig.getXmlRowTag());
        boolean useAttributeFormat = this.fileSinkConfig.getXmlUseAttrFormat();
        this.sinkColumnsIndexInRow.stream().map(index -> new AbstractMap.SimpleEntry<String, String>(this.seaTunnelRowType.getFieldName(index.intValue()), this.convertToXmlString(seaTunnelRow.getField(index.intValue()), this.seaTunnelRowType.getFieldType(index.intValue())))).forEach(entry -> {
            if (useAttributeFormat) {
                rowElement.addAttribute((String)entry.getKey(), (String)entry.getValue());
            } else {
                rowElement.addElement((String)entry.getKey()).addText((String)entry.getValue());
            }
        });
    }

    private String convertToXmlString(Object fieldValue, SeaTunnelDataType<?> fieldType) {
        if (fieldValue == null) {
            return "";
        }
        switch (fieldType.getSqlType()) {
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case BOOLEAN: {
                return fieldValue.toString();
            }
            case NULL: {
                return "";
            }
            case ROW: {
                Object[] fields = ((SeaTunnelRow)fieldValue).getFields();
                CharSequence[] strings = new String[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    strings[i] = this.convertToXmlString(fields[i], ((SeaTunnelRowType)fieldType).getFieldType(i));
                }
                return String.join((CharSequence)this.fieldDelimiter, strings);
            }
            case MAP: 
            case ARRAY: {
                return JsonUtils.toJsonString((Object)fieldValue);
            }
            case BYTES: {
                return new String((byte[])fieldValue, StandardCharsets.UTF_8);
            }
        }
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "SeaTunnel format not support this data type " + fieldType.getSqlType());
    }

    public void flushAndCloseXmlWriter(OutputStream output) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(output, this.format);
        xmlWriter.write(this.document);
        xmlWriter.close();
    }

    private void setXmlOutputFormat() {
        this.format = OutputFormat.createPrettyPrint();
        this.format.setNewlines(true);
        this.format.setNewLineAfterDeclaration(true);
        this.format.setSuppressDeclaration(false);
        this.format.setExpandEmptyElements(false);
        this.format.setIndent("\t");
        Charset charset = EncodingUtils.tryParseCharset((String)this.fileSinkConfig.getEncoding());
        this.format.setEncoding(charset.name());
    }
}

