/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.style;

import com.alibaba.excel.metadata.data.DataFormatData;
import com.alibaba.excel.metadata.property.FontProperty;
import com.alibaba.excel.metadata.property.StyleProperty;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.metadata.style.WriteFont;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class WriteCellStyle {
    private DataFormatData dataFormatData;
    private WriteFont writeFont;
    private Boolean hidden;
    private Boolean locked;
    private Boolean quotePrefix;
    private HorizontalAlignment horizontalAlignment;
    private Boolean wrapped;
    private VerticalAlignment verticalAlignment;
    private Short rotation;
    private Short indent;
    private BorderStyle borderLeft;
    private BorderStyle borderRight;
    private BorderStyle borderTop;
    private BorderStyle borderBottom;
    private Short leftBorderColor;
    private Short rightBorderColor;
    private Short topBorderColor;
    private Short bottomBorderColor;
    private FillPatternType fillPatternType;
    private Short fillBackgroundColor;
    private Short fillForegroundColor;
    private Boolean shrinkToFit;

    public static void merge(WriteCellStyle source, WriteCellStyle target) {
        if (source == null || target == null) {
            return;
        }
        if (source.getDataFormatData() != null) {
            if (target.getDataFormatData() == null) {
                target.setDataFormatData(source.getDataFormatData());
            } else {
                DataFormatData.merge(source.getDataFormatData(), target.getDataFormatData());
            }
        }
        if (source.getWriteFont() != null) {
            if (target.getWriteFont() == null) {
                target.setWriteFont(source.getWriteFont());
            } else {
                WriteFont.merge(source.getWriteFont(), target.getWriteFont());
            }
        }
        if (source.getHidden() != null) {
            target.setHidden(source.getHidden());
        }
        if (source.getLocked() != null) {
            target.setLocked(source.getLocked());
        }
        if (source.getQuotePrefix() != null) {
            target.setQuotePrefix(source.getQuotePrefix());
        }
        if (source.getHorizontalAlignment() != null) {
            target.setHorizontalAlignment(source.getHorizontalAlignment());
        }
        if (source.getWrapped() != null) {
            target.setWrapped(source.getWrapped());
        }
        if (source.getVerticalAlignment() != null) {
            target.setVerticalAlignment(source.getVerticalAlignment());
        }
        if (source.getRotation() != null) {
            target.setRotation(source.getRotation());
        }
        if (source.getIndent() != null) {
            target.setIndent(source.getIndent());
        }
        if (source.getBorderLeft() != null) {
            target.setBorderLeft(source.getBorderLeft());
        }
        if (source.getBorderRight() != null) {
            target.setBorderRight(source.getBorderRight());
        }
        if (source.getBorderTop() != null) {
            target.setBorderTop(source.getBorderTop());
        }
        if (source.getBorderBottom() != null) {
            target.setBorderBottom(source.getBorderBottom());
        }
        if (source.getLeftBorderColor() != null) {
            target.setLeftBorderColor(source.getLeftBorderColor());
        }
        if (source.getRightBorderColor() != null) {
            target.setRightBorderColor(source.getRightBorderColor());
        }
        if (source.getTopBorderColor() != null) {
            target.setTopBorderColor(source.getTopBorderColor());
        }
        if (source.getBottomBorderColor() != null) {
            target.setBottomBorderColor(source.getBottomBorderColor());
        }
        if (source.getFillPatternType() != null) {
            target.setFillPatternType(source.getFillPatternType());
        }
        if (source.getFillBackgroundColor() != null) {
            target.setFillBackgroundColor(source.getFillBackgroundColor());
        }
        if (source.getFillForegroundColor() != null) {
            target.setFillForegroundColor(source.getFillForegroundColor());
        }
        if (source.getShrinkToFit() != null) {
            target.setShrinkToFit(source.getShrinkToFit());
        }
    }

    public static WriteCellStyle build(StyleProperty styleProperty, FontProperty fontProperty) {
        if (styleProperty == null && fontProperty == null) {
            return null;
        }
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        WriteCellStyle.buildStyleProperty(styleProperty, writeCellStyle);
        WriteCellStyle.buildFontProperty(fontProperty, writeCellStyle);
        return writeCellStyle;
    }

    private static void buildFontProperty(FontProperty fontProperty, WriteCellStyle writeCellStyle) {
        if (fontProperty == null) {
            return;
        }
        if (writeCellStyle.getWriteFont() == null) {
            writeCellStyle.setWriteFont(new WriteFont());
        }
        WriteFont writeFont = writeCellStyle.getWriteFont();
        if (StringUtils.isNotBlank(fontProperty.getFontName())) {
            writeFont.setFontName(fontProperty.getFontName());
        }
        if (fontProperty.getFontHeightInPoints() != null) {
            writeFont.setFontHeightInPoints(fontProperty.getFontHeightInPoints());
        }
        if (fontProperty.getItalic() != null) {
            writeFont.setItalic(fontProperty.getItalic());
        }
        if (fontProperty.getStrikeout() != null) {
            writeFont.setStrikeout(fontProperty.getStrikeout());
        }
        if (fontProperty.getColor() != null) {
            writeFont.setColor(fontProperty.getColor());
        }
        if (fontProperty.getTypeOffset() != null) {
            writeFont.setTypeOffset(fontProperty.getTypeOffset());
        }
        if (fontProperty.getUnderline() != null) {
            writeFont.setUnderline(fontProperty.getUnderline());
        }
        if (fontProperty.getCharset() != null) {
            writeFont.setCharset(fontProperty.getCharset());
        }
        if (fontProperty.getBold() != null) {
            writeFont.setBold(fontProperty.getBold());
        }
    }

    private static void buildStyleProperty(StyleProperty styleProperty, WriteCellStyle writeCellStyle) {
        if (styleProperty == null) {
            return;
        }
        if (styleProperty.getDataFormatData() != null) {
            if (writeCellStyle.getDataFormatData() == null) {
                writeCellStyle.setDataFormatData(styleProperty.getDataFormatData());
            } else {
                DataFormatData.merge(styleProperty.getDataFormatData(), writeCellStyle.getDataFormatData());
            }
        }
        if (styleProperty.getHidden() != null) {
            writeCellStyle.setHidden(styleProperty.getHidden());
        }
        if (styleProperty.getLocked() != null) {
            writeCellStyle.setLocked(styleProperty.getLocked());
        }
        if (styleProperty.getQuotePrefix() != null) {
            writeCellStyle.setQuotePrefix(styleProperty.getQuotePrefix());
        }
        if (styleProperty.getHorizontalAlignment() != null) {
            writeCellStyle.setHorizontalAlignment(styleProperty.getHorizontalAlignment());
        }
        if (styleProperty.getWrapped() != null) {
            writeCellStyle.setWrapped(styleProperty.getWrapped());
        }
        if (styleProperty.getVerticalAlignment() != null) {
            writeCellStyle.setVerticalAlignment(styleProperty.getVerticalAlignment());
        }
        if (styleProperty.getRotation() != null) {
            writeCellStyle.setRotation(styleProperty.getRotation());
        }
        if (styleProperty.getIndent() != null) {
            writeCellStyle.setIndent(styleProperty.getIndent());
        }
        if (styleProperty.getBorderLeft() != null) {
            writeCellStyle.setBorderLeft(styleProperty.getBorderLeft());
        }
        if (styleProperty.getBorderRight() != null) {
            writeCellStyle.setBorderRight(styleProperty.getBorderRight());
        }
        if (styleProperty.getBorderTop() != null) {
            writeCellStyle.setBorderTop(styleProperty.getBorderTop());
        }
        if (styleProperty.getBorderBottom() != null) {
            writeCellStyle.setBorderBottom(styleProperty.getBorderBottom());
        }
        if (styleProperty.getLeftBorderColor() != null) {
            writeCellStyle.setLeftBorderColor(styleProperty.getLeftBorderColor());
        }
        if (styleProperty.getRightBorderColor() != null) {
            writeCellStyle.setRightBorderColor(styleProperty.getRightBorderColor());
        }
        if (styleProperty.getTopBorderColor() != null) {
            writeCellStyle.setTopBorderColor(styleProperty.getTopBorderColor());
        }
        if (styleProperty.getBottomBorderColor() != null) {
            writeCellStyle.setBottomBorderColor(styleProperty.getBottomBorderColor());
        }
        if (styleProperty.getFillPatternType() != null) {
            writeCellStyle.setFillPatternType(styleProperty.getFillPatternType());
        }
        if (styleProperty.getFillBackgroundColor() != null) {
            writeCellStyle.setFillBackgroundColor(styleProperty.getFillBackgroundColor());
        }
        if (styleProperty.getFillForegroundColor() != null) {
            writeCellStyle.setFillForegroundColor(styleProperty.getFillForegroundColor());
        }
        if (styleProperty.getShrinkToFit() != null) {
            writeCellStyle.setShrinkToFit(styleProperty.getShrinkToFit());
        }
    }

    public DataFormatData getDataFormatData() {
        return this.dataFormatData;
    }

    public WriteFont getWriteFont() {
        return this.writeFont;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Boolean getQuotePrefix() {
        return this.quotePrefix;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Boolean getWrapped() {
        return this.wrapped;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public Short getRotation() {
        return this.rotation;
    }

    public Short getIndent() {
        return this.indent;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public Short getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public Short getRightBorderColor() {
        return this.rightBorderColor;
    }

    public Short getTopBorderColor() {
        return this.topBorderColor;
    }

    public Short getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public FillPatternType getFillPatternType() {
        return this.fillPatternType;
    }

    public Short getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public Short getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    public Boolean getShrinkToFit() {
        return this.shrinkToFit;
    }

    public void setDataFormatData(DataFormatData dataFormatData) {
        this.dataFormatData = dataFormatData;
    }

    public void setWriteFont(WriteFont writeFont) {
        this.writeFont = writeFont;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setQuotePrefix(Boolean quotePrefix) {
        this.quotePrefix = quotePrefix;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setWrapped(Boolean wrapped) {
        this.wrapped = wrapped;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setRotation(Short rotation) {
        this.rotation = rotation;
    }

    public void setIndent(Short indent) {
        this.indent = indent;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public void setLeftBorderColor(Short leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public void setRightBorderColor(Short rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public void setTopBorderColor(Short topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public void setBottomBorderColor(Short bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public void setFillPatternType(FillPatternType fillPatternType) {
        this.fillPatternType = fillPatternType;
    }

    public void setFillBackgroundColor(Short fillBackgroundColor) {
        this.fillBackgroundColor = fillBackgroundColor;
    }

    public void setFillForegroundColor(Short fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    public void setShrinkToFit(Boolean shrinkToFit) {
        this.shrinkToFit = shrinkToFit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteCellStyle)) {
            return false;
        }
        WriteCellStyle other = (WriteCellStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        Boolean this$quotePrefix = this.getQuotePrefix();
        Boolean other$quotePrefix = other.getQuotePrefix();
        if (this$quotePrefix == null ? other$quotePrefix != null : !((Object)this$quotePrefix).equals(other$quotePrefix)) {
            return false;
        }
        Boolean this$wrapped = this.getWrapped();
        Boolean other$wrapped = other.getWrapped();
        if (this$wrapped == null ? other$wrapped != null : !((Object)this$wrapped).equals(other$wrapped)) {
            return false;
        }
        Short this$rotation = this.getRotation();
        Short other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
            return false;
        }
        Short this$indent = this.getIndent();
        Short other$indent = other.getIndent();
        if (this$indent == null ? other$indent != null : !((Object)this$indent).equals(other$indent)) {
            return false;
        }
        Short this$leftBorderColor = this.getLeftBorderColor();
        Short other$leftBorderColor = other.getLeftBorderColor();
        if (this$leftBorderColor == null ? other$leftBorderColor != null : !((Object)this$leftBorderColor).equals(other$leftBorderColor)) {
            return false;
        }
        Short this$rightBorderColor = this.getRightBorderColor();
        Short other$rightBorderColor = other.getRightBorderColor();
        if (this$rightBorderColor == null ? other$rightBorderColor != null : !((Object)this$rightBorderColor).equals(other$rightBorderColor)) {
            return false;
        }
        Short this$topBorderColor = this.getTopBorderColor();
        Short other$topBorderColor = other.getTopBorderColor();
        if (this$topBorderColor == null ? other$topBorderColor != null : !((Object)this$topBorderColor).equals(other$topBorderColor)) {
            return false;
        }
        Short this$bottomBorderColor = this.getBottomBorderColor();
        Short other$bottomBorderColor = other.getBottomBorderColor();
        if (this$bottomBorderColor == null ? other$bottomBorderColor != null : !((Object)this$bottomBorderColor).equals(other$bottomBorderColor)) {
            return false;
        }
        Short this$fillBackgroundColor = this.getFillBackgroundColor();
        Short other$fillBackgroundColor = other.getFillBackgroundColor();
        if (this$fillBackgroundColor == null ? other$fillBackgroundColor != null : !((Object)this$fillBackgroundColor).equals(other$fillBackgroundColor)) {
            return false;
        }
        Short this$fillForegroundColor = this.getFillForegroundColor();
        Short other$fillForegroundColor = other.getFillForegroundColor();
        if (this$fillForegroundColor == null ? other$fillForegroundColor != null : !((Object)this$fillForegroundColor).equals(other$fillForegroundColor)) {
            return false;
        }
        Boolean this$shrinkToFit = this.getShrinkToFit();
        Boolean other$shrinkToFit = other.getShrinkToFit();
        if (this$shrinkToFit == null ? other$shrinkToFit != null : !((Object)this$shrinkToFit).equals(other$shrinkToFit)) {
            return false;
        }
        DataFormatData this$dataFormatData = this.getDataFormatData();
        DataFormatData other$dataFormatData = other.getDataFormatData();
        if (this$dataFormatData == null ? other$dataFormatData != null : !((Object)this$dataFormatData).equals(other$dataFormatData)) {
            return false;
        }
        WriteFont this$writeFont = this.getWriteFont();
        WriteFont other$writeFont = other.getWriteFont();
        if (this$writeFont == null ? other$writeFont != null : !((Object)this$writeFont).equals(other$writeFont)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !((Object)((Object)this$horizontalAlignment)).equals((Object)other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        if (this$verticalAlignment == null ? other$verticalAlignment != null : !((Object)((Object)this$verticalAlignment)).equals((Object)other$verticalAlignment)) {
            return false;
        }
        BorderStyle this$borderLeft = this.getBorderLeft();
        BorderStyle other$borderLeft = other.getBorderLeft();
        if (this$borderLeft == null ? other$borderLeft != null : !((Object)((Object)this$borderLeft)).equals((Object)other$borderLeft)) {
            return false;
        }
        BorderStyle this$borderRight = this.getBorderRight();
        BorderStyle other$borderRight = other.getBorderRight();
        if (this$borderRight == null ? other$borderRight != null : !((Object)((Object)this$borderRight)).equals((Object)other$borderRight)) {
            return false;
        }
        BorderStyle this$borderTop = this.getBorderTop();
        BorderStyle other$borderTop = other.getBorderTop();
        if (this$borderTop == null ? other$borderTop != null : !((Object)((Object)this$borderTop)).equals((Object)other$borderTop)) {
            return false;
        }
        BorderStyle this$borderBottom = this.getBorderBottom();
        BorderStyle other$borderBottom = other.getBorderBottom();
        if (this$borderBottom == null ? other$borderBottom != null : !((Object)((Object)this$borderBottom)).equals((Object)other$borderBottom)) {
            return false;
        }
        FillPatternType this$fillPatternType = this.getFillPatternType();
        FillPatternType other$fillPatternType = other.getFillPatternType();
        return !(this$fillPatternType == null ? other$fillPatternType != null : !((Object)((Object)this$fillPatternType)).equals((Object)other$fillPatternType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WriteCellStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        Boolean $quotePrefix = this.getQuotePrefix();
        result = result * 59 + ($quotePrefix == null ? 43 : ((Object)$quotePrefix).hashCode());
        Boolean $wrapped = this.getWrapped();
        result = result * 59 + ($wrapped == null ? 43 : ((Object)$wrapped).hashCode());
        Short $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
        Short $indent = this.getIndent();
        result = result * 59 + ($indent == null ? 43 : ((Object)$indent).hashCode());
        Short $leftBorderColor = this.getLeftBorderColor();
        result = result * 59 + ($leftBorderColor == null ? 43 : ((Object)$leftBorderColor).hashCode());
        Short $rightBorderColor = this.getRightBorderColor();
        result = result * 59 + ($rightBorderColor == null ? 43 : ((Object)$rightBorderColor).hashCode());
        Short $topBorderColor = this.getTopBorderColor();
        result = result * 59 + ($topBorderColor == null ? 43 : ((Object)$topBorderColor).hashCode());
        Short $bottomBorderColor = this.getBottomBorderColor();
        result = result * 59 + ($bottomBorderColor == null ? 43 : ((Object)$bottomBorderColor).hashCode());
        Short $fillBackgroundColor = this.getFillBackgroundColor();
        result = result * 59 + ($fillBackgroundColor == null ? 43 : ((Object)$fillBackgroundColor).hashCode());
        Short $fillForegroundColor = this.getFillForegroundColor();
        result = result * 59 + ($fillForegroundColor == null ? 43 : ((Object)$fillForegroundColor).hashCode());
        Boolean $shrinkToFit = this.getShrinkToFit();
        result = result * 59 + ($shrinkToFit == null ? 43 : ((Object)$shrinkToFit).hashCode());
        DataFormatData $dataFormatData = this.getDataFormatData();
        result = result * 59 + ($dataFormatData == null ? 43 : ((Object)$dataFormatData).hashCode());
        WriteFont $writeFont = this.getWriteFont();
        result = result * 59 + ($writeFont == null ? 43 : ((Object)$writeFont).hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : ((Object)((Object)$horizontalAlignment)).hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : ((Object)((Object)$verticalAlignment)).hashCode());
        BorderStyle $borderLeft = this.getBorderLeft();
        result = result * 59 + ($borderLeft == null ? 43 : ((Object)((Object)$borderLeft)).hashCode());
        BorderStyle $borderRight = this.getBorderRight();
        result = result * 59 + ($borderRight == null ? 43 : ((Object)((Object)$borderRight)).hashCode());
        BorderStyle $borderTop = this.getBorderTop();
        result = result * 59 + ($borderTop == null ? 43 : ((Object)((Object)$borderTop)).hashCode());
        BorderStyle $borderBottom = this.getBorderBottom();
        result = result * 59 + ($borderBottom == null ? 43 : ((Object)((Object)$borderBottom)).hashCode());
        FillPatternType $fillPatternType = this.getFillPatternType();
        result = result * 59 + ($fillPatternType == null ? 43 : ((Object)((Object)$fillPatternType)).hashCode());
        return result;
    }
}

