/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.util;

import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRecord;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.TypeConvertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseUtil {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseUtil.class);

    public static List<ClickHouseNode> createNodes(ReadonlyConfig config) {
        return ClickhouseUtil.createNodes((String)config.get(ClickhouseBaseOptions.HOST), (String)config.get(ClickhouseBaseOptions.DATABASE), (String)config.get(ClickhouseBaseOptions.SERVER_TIME_ZONE), (String)config.get(ClickhouseBaseOptions.USERNAME), (String)config.get(ClickhouseBaseOptions.PASSWORD), (Map)config.get(ClickhouseBaseOptions.CLICKHOUSE_CONFIG));
    }

    public static List<ClickHouseNode> createNodes(String nodeAddress, String database, String serverTimeZone, String username, String password, Map<String, String> options) {
        return Arrays.stream(nodeAddress.split(",")).map(address -> {
            String[] nodeAndPort = address.split(":", 2);
            ClickHouseNode.Builder builder = ClickHouseNode.builder().host(nodeAndPort[0]).port(ClickHouseProtocol.HTTP, Integer.parseInt(nodeAndPort[1])).database(database).timeZone(serverTimeZone);
            if (MapUtils.isNotEmpty((Map)options)) {
                for (Map.Entry entry : options.entrySet()) {
                    builder = builder.addOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                builder = builder.credentials(ClickHouseCredentials.fromUserAndPassword(username, password));
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    public static SeaTunnelRow convertToSeaTunnelRow(ClickHouseRecord record, SeaTunnelRowType seaTunnelRowType, String tableId) {
        Object[] values = new Object[seaTunnelRowType.getFieldNames().length];
        for (int i = 0; i < record.size(); ++i) {
            values[i] = record.getValue(i) == null || record.getValue(i).isNullOrEmpty() ? null : TypeConvertUtil.valueUnwrap(seaTunnelRowType.getFieldType(i), record.getValue(i));
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(values);
        seaTunnelRow.setTableId(tableId);
        return seaTunnelRow;
    }

    public static TablePath extractTablePathFromSql(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse(sql);
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            Set<String> tableNames = tablesNamesFinder.getTables(statement);
            if (tableNames.size() == 1) {
                String tableFullName = tableNames.iterator().next();
                return TablePath.of((String)tableFullName);
            }
            return TablePath.DEFAULT;
        }
        catch (JSQLParserException e) {
            log.warn("Failed to parse SQL statement: {}, exception: {}", (Object)sql, (Object)e);
            return TablePath.DEFAULT;
        }
    }
}

