/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.catalog.ClickhouseTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.common.util.CatalogUtil;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class ClickhouseCatalogUtil
extends CatalogUtil {
    public static final ClickhouseCatalogUtil INSTANCE = new ClickhouseCatalogUtil();

    @Override
    public String columnToConnectorType(Column column) {
        Preconditions.checkNotNull((Object)column, (Object)"The column is required.");
        String columnType = column.getSinkType() != null ? column.getSinkType() : ClickhouseTypeConverter.INSTANCE.reconvert(column).getColumnType();
        return String.format("`%s` %s %s", column.getName(), columnType, StringUtils.isEmpty(column.getComment()) ? "" : "COMMENT '" + column.getComment().replace("'", "''").replace("\\", "\\\\") + "'");
    }

    @Override
    public String getDropTableSql(TablePath tablePath, boolean ignoreIfNotExists) {
        if (ignoreIfNotExists) {
            return "DROP TABLE IF EXISTS " + tablePath.getDatabaseName() + "." + tablePath.getTableName();
        }
        return "DROP TABLE " + tablePath.getDatabaseName() + "." + tablePath.getTableName();
    }

    @Override
    public String getTruncateTableSql(TablePath tablePath) {
        return "TRUNCATE TABLE " + tablePath.getDatabaseName() + "." + tablePath.getTableName();
    }
}

