/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split;

import com.clickhouse.client.ClickHouseNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.shard.Shard;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.ClickhouseSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.Splitter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.ClickhouseSourceState;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.DistributedEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseSourceSplitEnumerator
implements SourceSplitEnumerator<ClickhouseSourceSplit, ClickhouseSourceState> {
    private static final Logger LOG = LoggerFactory.getLogger(ClickhouseSourceSplitEnumerator.class);
    private final ClickhouseSourceConfig clickhouseSourceConfig;
    private final Map<TablePath, ClickhouseSourceTable> clickhouseSourceTables;
    private volatile boolean shouldEnumerate;
    private final Map<Integer, List<ClickhouseSourceSplit>> pendingSplit;
    private final SourceSplitEnumerator.Context<ClickhouseSourceSplit> context;
    private final Map<TablePath, List<ClickHouseNode>> nodesMap;
    private final Object stateLock = new Object();

    public ClickhouseSourceSplitEnumerator(SourceSplitEnumerator.Context<ClickhouseSourceSplit> context, ClickhouseSourceConfig clickhouseSourceConfig, Map<TablePath, ClickhouseSourceTable> clickhouseSourceTables, Map<TablePath, List<ClickHouseNode>> nodes) {
        this(context, clickhouseSourceConfig, clickhouseSourceTables, nodes, null);
    }

    public ClickhouseSourceSplitEnumerator(SourceSplitEnumerator.Context<ClickhouseSourceSplit> context, ClickhouseSourceConfig clickhouseSourceConfig, Map<TablePath, ClickhouseSourceTable> clickhouseSourceTables, Map<TablePath, List<ClickHouseNode>> nodes, ClickhouseSourceState sourceState) {
        this.context = context;
        this.clickhouseSourceConfig = clickhouseSourceConfig;
        this.clickhouseSourceTables = clickhouseSourceTables;
        this.nodesMap = nodes;
        this.pendingSplit = new ConcurrentHashMap<Integer, List<ClickhouseSourceSplit>>();
        boolean bl = this.shouldEnumerate = sourceState == null;
        if (sourceState != null) {
            this.shouldEnumerate = sourceState.isShouldEnumerate();
            this.pendingSplit.putAll(sourceState.getPendingSplit());
        }
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        LOG.info("Starting split enumerator.");
        Set readers = this.context.registeredReaders();
        if (this.shouldEnumerate) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.shouldEnumerate) {
                    List<ClickhouseSourceSplit> clickhouseSourceSplits = this.getClickhouseSourceSplits();
                    this.addPendingSplit(clickhouseSourceSplits);
                    this.shouldEnumerate = false;
                    this.assignSplit(readers);
                }
            }
        }
        LOG.info("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> this.context.signalNoMoreSplits(arg_0));
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<ClickhouseSourceSplit> splits, int subtaskId) {
        if (!splits.isEmpty()) {
            this.addPendingSplit(splits, subtaskId);
            if (this.context.registeredReaders().contains(subtaskId)) {
                this.assignSplit(Collections.singletonList(subtaskId));
            } else {
                LOG.warn("Reader {} is not registered. Pending splits {} are not assigned.", (Object)subtaskId, splits);
            }
        }
        LOG.info("Add back splits {} to JdbcSourceSplitEnumerator.", (Object)splits.size());
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplit.size();
    }

    public void handleSplitRequest(int subtaskId) {
        throw new ClickhouseConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported handleSplitRequest: %d", subtaskId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReader(int subtaskId) {
        LOG.info("Register reader {} to ClickhouseSourceSplitEnumerator.", (Object)subtaskId);
        if (!this.pendingSplit.isEmpty()) {
            Object object = this.stateLock;
            synchronized (object) {
                this.assignSplit(Collections.singletonList(subtaskId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClickhouseSourceState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new ClickhouseSourceState(this.shouldEnumerate, this.pendingSplit);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    private List<ClickhouseSourceSplit> getClickhouseSourceSplits() {
        ArrayList<ClickhouseSourceSplit> splits = new ArrayList<ClickhouseSourceSplit>();
        for (Map.Entry<TablePath, ClickhouseSourceTable> entry : this.clickhouseSourceTables.entrySet()) {
            List<ClickHouseNode> nodes = this.nodesMap.get(entry.getKey());
            ClickhouseSourceTable clickhouseSourceTable = entry.getValue();
            List<Shard> clusterShardList = this.getClusterShardList(clickhouseSourceTable, nodes);
            Splitter splitter = Splitter.createSplitter(clickhouseSourceTable);
            List<ClickhouseSourceSplit> sourceSplits = splitter.generateSplits(clickhouseSourceTable, clusterShardList);
            LOG.info("Generated {} splits for table {}.", (Object)sourceSplits.size(), (Object)entry.getKey());
            splits.addAll(sourceSplits);
            splitter.close();
        }
        return splits;
    }

    private void assignSplit(Collection<Integer> readers) {
        LOG.debug("Assign pendingSplits to readers {}", readers);
        for (int reader : readers) {
            List<ClickhouseSourceSplit> assignmentForReader = this.pendingSplit.remove(reader);
            if (assignmentForReader == null || assignmentForReader.isEmpty()) continue;
            LOG.debug("Assign splits {} to reader {}", assignmentForReader, (Object)reader);
            this.context.assignSplit(reader, assignmentForReader);
        }
    }

    private void addPendingSplit(Collection<ClickhouseSourceSplit> splits) {
        int readerCount = this.context.currentParallelism();
        for (ClickhouseSourceSplit split : splits) {
            int ownerReader = ClickhouseSourceSplitEnumerator.getSplitOwner(split.splitId(), readerCount);
            LOG.debug("Assigning {} to {} reader.", (Object)split, (Object)ownerReader);
            this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).add(split);
        }
    }

    private void addPendingSplit(Collection<ClickhouseSourceSplit> splits, int ownerReader) {
        this.pendingSplit.computeIfAbsent(ownerReader, r -> new ArrayList()).addAll(splits);
    }

    private static int getSplitOwner(String tp, int numReaders) {
        return (tp.hashCode() & Integer.MAX_VALUE) % numReaders;
    }

    private List<Shard> getClusterShardList(ClickhouseSourceTable clickhouseSourceTable, List<ClickHouseNode> nodes) {
        ClickhouseTable clickhouseTable = clickhouseSourceTable.getClickhouseTable();
        ClickHouseNode currentNode = nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
        try (ClickhouseProxy proxy = new ClickhouseProxy(currentNode);){
            List<Shard> clusterShardList;
            String localTableEngine;
            if (clickhouseSourceTable.isComplexSql()) {
                List<Shard> list = this.buildClusterShardFromNodes(nodes);
                return list;
            }
            if (clickhouseTable.getDistributedEngine() != null) {
                DistributedEngine distributedEngine = clickhouseTable.getDistributedEngine();
                localTableEngine = distributedEngine.getTableEngine();
                clusterShardList = proxy.getClusterShardList(proxy.getClickhouseConnection(), distributedEngine.getClusterName(), distributedEngine.getDatabase(), nodes.get(0).getPort(), this.clickhouseSourceConfig.getUsername(), this.clickhouseSourceConfig.getPassword(), nodes.get(0).getOptions());
            } else {
                clusterShardList = this.buildClusterShardFromNodes(nodes);
                localTableEngine = clickhouseTable.getEngine();
            }
            if (StringUtils.isEmpty(clickhouseSourceTable.getOriginQuery()) && !localTableEngine.contains("MergeTree")) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)ClickhouseConnectorErrorCode.QUERY_TABLE_NOT_SUPPORT_NON_MERGE_TREE_TABLE, "Query table mode not support non-MergeTree local table. Please specify sql parameter in configuration");
            }
            List<Shard> list = clusterShardList;
            return list;
        }
    }

    private List<Shard> buildClusterShardFromNodes(List<ClickHouseNode> nodes) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        IntStream.range(0, nodes.size()).forEach(i -> {
            ClickHouseNode node = (ClickHouseNode)nodes.get(i);
            Shard shard = new Shard(i, 1, node);
            shards.add(shard);
        });
        return shards;
    }
}

