/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseTableConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.exception.ClickhouseConnectorException;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSource;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseProxy;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.ClickhouseUtil;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.util.TypeConvertUtil;

@AutoService(value={Factory.class})
public class ClickhouseSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Clickhouse";
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        ClickhouseSourceConfig clickhouseSourceConfig = ClickhouseSourceConfig.of(context.getOptions());
        List<ClickhouseTableConfig> tableConfigs = clickhouseSourceConfig.getTableconfigList();
        HashMap<TablePath, ClickhouseSourceTable> clickhouseSourceTables = new HashMap<TablePath, ClickhouseSourceTable>();
        HashMap<TablePath, List<ClickHouseNode>> nodesMap = new HashMap<TablePath, List<ClickHouseNode>>();
        for (ClickhouseTableConfig tableConfig : tableConfigs) {
            String sql = tableConfig.getSql();
            TablePath tablePath = tableConfig.getTableIdentifier();
            List<ClickHouseNode> nodes = ClickhouseUtil.createNodes(clickhouseSourceConfig.getHost(), tablePath.getDatabaseName(), clickhouseSourceConfig.getServerTimeZone(), clickhouseSourceConfig.getUsername(), clickhouseSourceConfig.getPassword(), clickhouseSourceConfig.getClickhouseConfig());
            ClickHouseNode currentServer = nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            try {
                ClickhouseProxy proxy = new ClickhouseProxy(currentServer);
                Throwable throwable = null;
                try {
                    ClickHouseResponse response = ((ClickHouseRequest)proxy.getClickhouseConnection().query(this.generateQuerySql(sql, tablePath.getDatabaseName(), tablePath.getTableName()))).executeAndWait();
                    Throwable throwable2 = null;
                    try {
                        TableSchema.Builder builder = TableSchema.builder();
                        List<ClickHouseColumn> columns = response.getColumns();
                        columns.forEach(column -> {
                            PhysicalColumn physicalColumn = PhysicalColumn.of((String)column.getColumnName(), TypeConvertUtil.convert(column), (Long)Long.valueOf(column.getEstimatedLength()), (Integer)column.getScale(), (boolean)column.isNullable(), null, null);
                            builder.column((Column)physicalColumn);
                        });
                        String catalogName = "clickhouse_catalog";
                        CatalogTable catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName()), (TableSchema)builder.build(), Collections.emptyMap(), Collections.emptyList(), (String)"", (String)catalogName);
                        boolean isComplexSql = StringUtils.isNotEmpty(sql) && (tablePath == TablePath.DEFAULT || proxy.isComplexSql(sql));
                        ClickhouseTable clickhouseTable = isComplexSql ? null : proxy.getClickhouseTable(proxy.getClickhouseConnection(), tablePath.getDatabaseName(), tablePath.getTableName());
                        ClickhouseSourceTable clickhouseSourceTable = ClickhouseSourceTable.builder().tablePath(tablePath).clickhouseTable(clickhouseTable).originQuery(sql).filterQuery(tableConfig.getFilterQuery()).splitSize(tableConfig.getSplitSize()).batchSize(tableConfig.getBatchSize()).partitionList(tableConfig.getPartitionList()).isSqlStrategyRead(tableConfig.isSqlStrategyRead()).isComplexSql(isComplexSql).catalogTable(catalogTable).build();
                        clickhouseSourceTables.put(tablePath, clickhouseSourceTable);
                        nodesMap.put(tablePath, nodes);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        response.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (proxy == null) continue;
                    if (throwable != null) {
                        try {
                            proxy.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    proxy.close();
                }
            }
            catch (ClickHouseException e) {
                throw new ClickhouseConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.factoryIdentifier(), PluginType.SOURCE, e.getMessage()));
            }
        }
        return () -> new ClickhouseSource(nodesMap, clickhouseSourceTables, clickhouseSourceConfig);
    }

    private String modifySQLToLimit1(String sql) {
        return String.format("SELECT * FROM (%s) s LIMIT 1", sql);
    }

    private String generateQuerySql(String sql, String database, String table) {
        if (StringUtils.isNotEmpty(sql)) {
            return this.modifySQLToLimit1(sql);
        }
        return String.format("SELECT * FROM %s.%s LIMIT 1", database, table);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{ClickhouseBaseOptions.HOST, ClickhouseBaseOptions.USERNAME, ClickhouseBaseOptions.PASSWORD}).optional(new Option[]{ClickhouseBaseOptions.TABLE_PATH, ClickhouseBaseOptions.CLICKHOUSE_CONFIG, ClickhouseBaseOptions.SERVER_TIME_ZONE, ClickhouseSourceOptions.SQL, ClickhouseSourceOptions.CLICKHOUSE_SPLIT_SIZE, ClickhouseSourceOptions.CLICKHOUSE_PARTITION_LIST, ClickhouseSourceOptions.CLICKHOUSE_BATCH_SIZE, ClickhouseSourceOptions.CLICKHOUSE_FILTER_QUERY}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return ClickhouseSource.class;
    }
}

