/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source;

import com.clickhouse.client.ClickHouseNode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceReader;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceTable;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.ClickhouseSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.split.ClickhouseSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.ClickhouseSourceState;

public class ClickhouseSource
implements SeaTunnelSource<SeaTunnelRow, ClickhouseSourceSplit, ClickhouseSourceState> {
    private final Map<TablePath, List<ClickHouseNode>> servers;
    private final ClickhouseSourceConfig clickhouseSourceConfig;
    private final Map<TablePath, ClickhouseSourceTable> clickhouseSourceTables;

    public ClickhouseSource(Map<TablePath, List<ClickHouseNode>> servers, Map<TablePath, ClickhouseSourceTable> clickhouseSourceTables, ClickhouseSourceConfig clickhouseSourceConfig) {
        this.servers = servers;
        this.clickhouseSourceTables = clickhouseSourceTables;
        this.clickhouseSourceConfig = clickhouseSourceConfig;
    }

    public String getPluginName() {
        return "Clickhouse";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.clickhouseSourceTables.values().stream().map(ClickhouseSourceTable::getCatalogTable).collect(Collectors.toList());
    }

    public SourceReader<SeaTunnelRow, ClickhouseSourceSplit> createReader(SourceReader.Context readerContext) {
        return new ClickhouseSourceReader(this.servers, readerContext, this.clickhouseSourceTables);
    }

    public SourceSplitEnumerator<ClickhouseSourceSplit, ClickhouseSourceState> createEnumerator(SourceSplitEnumerator.Context<ClickhouseSourceSplit> enumeratorContext) {
        return new ClickhouseSourceSplitEnumerator(enumeratorContext, this.clickhouseSourceConfig, this.clickhouseSourceTables, this.servers);
    }

    public SourceSplitEnumerator<ClickhouseSourceSplit, ClickhouseSourceState> restoreEnumerator(SourceSplitEnumerator.Context<ClickhouseSourceSplit> enumeratorContext, ClickhouseSourceState checkpointState) {
        return new ClickhouseSourceSplitEnumerator(enumeratorContext, this.clickhouseSourceConfig, this.clickhouseSourceTables, this.servers, checkpointState);
    }
}

