/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.catalog;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeConverter;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class ClickhouseTypeConverter
implements BasicTypeConverter<BasicTypeDefine<ClickhouseType>> {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseTypeConverter.class);
    public static final ClickhouseTypeConverter INSTANCE = new ClickhouseTypeConverter();
    public static final Integer MAX_DATETIME_SCALE = 9;
    public static final String IDENTIFIER = "Clickhouse";

    public String identifier() {
        return IDENTIFIER;
    }

    public Column convert(BasicTypeDefine<ClickhouseType> typeDefine) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public BasicTypeDefine<ClickhouseType> reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType("Bool");
                builder.dataType("Bool");
                break;
            }
            case TINYINT: {
                builder.columnType("Int8");
                builder.dataType("Int8");
                break;
            }
            case SMALLINT: {
                builder.columnType("Int16");
                builder.dataType("Int16");
                break;
            }
            case INT: {
                builder.columnType("Int32");
                builder.dataType("Int32");
                break;
            }
            case BIGINT: {
                builder.columnType("Int64");
                builder.dataType("Int64");
                break;
            }
            case FLOAT: {
                builder.columnType("Float32");
                builder.dataType("Float32");
                break;
            }
            case DOUBLE: {
                builder.columnType("Float64");
                builder.dataType("Float64");
                break;
            }
            case DATE: {
                builder.columnType("Date");
                builder.dataType("Date");
                break;
            }
            case TIME: 
            case STRING: {
                builder.columnType("String");
                builder.dataType("String");
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                builder.columnType(String.format("%s(%s, %s)", "Decimal", decimalType.getPrecision(), decimalType.getScale()));
                builder.dataType("Decimal");
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() != null && column.getScale() > 0 && column.getScale() <= MAX_DATETIME_SCALE) {
                    builder.columnType(String.format("%s(%s)", "DateTime64", column.getScale()));
                    builder.scale(column.getScale());
                } else {
                    builder.columnType(String.format("%s(%s)", "DateTime64", 0));
                    builder.scale(Integer.valueOf(0));
                }
                builder.dataType("DateTime64");
                break;
            }
            case MAP: {
                MapType dataType = (MapType)column.getDataType();
                SeaTunnelDataType keyType = dataType.getKeyType();
                SeaTunnelDataType valueType = dataType.getValueType();
                PhysicalColumn keyColumn = PhysicalColumn.of((String)(column.getName() + ".key"), (SeaTunnelDataType)keyType, (Long)null, (boolean)true, null, null);
                String keyColumnType = this.reconvert((Column)keyColumn).getColumnType();
                PhysicalColumn valueColumn = PhysicalColumn.of((String)(column.getName() + ".value"), (SeaTunnelDataType)valueType, (Long)null, (boolean)true, null, null);
                String valueColumnType = this.reconvert((Column)valueColumn).getColumnType();
                builder.dataType("Map");
                builder.columnType(String.format("%s(%s, %s)", "Map", keyColumnType, valueColumnType));
                break;
            }
            case ARRAY: {
                SeaTunnelDataType arrayDataType = column.getDataType();
                SeaTunnelDataType elementType = null;
                if (arrayDataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)arrayDataType;
                    elementType = arrayType.getElementType();
                }
                PhysicalColumn arrayKeyColumn = PhysicalColumn.of((String)(column.getName() + ".key"), (SeaTunnelDataType)elementType, (Long)null, (boolean)true, null, null);
                String arrayKeyColumnType = this.reconvert((Column)arrayKeyColumn).getColumnType();
                builder.dataType("Array");
                builder.columnType(String.format("%s(%s)", "Array", arrayKeyColumnType));
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)IDENTIFIER, (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

