/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.SQLUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver.SqlserverTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDialect
implements JdbcDialect {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDialect.class);
    public String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public SqlServerDialect() {
    }

    public SqlServerDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "SqlServer";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new SqlserverJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new SqlserverTypeMapper();
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        return "ABS(HASHBYTES('MD5', " + this.quoteIdentifier(fieldName) + ") % " + mod + ")";
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(fieldName -> !Arrays.asList(uniqueKeyFields).contains(fieldName)).collect(Collectors.toList());
        String valuesBinding = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName + " " + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(fieldName -> String.format("[TARGET].%s=[SOURCE].%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(fieldName -> String.format("[TARGET].%s=[SOURCE].%s", this.quoteIdentifier((String)fieldName), this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(fieldName -> "[SOURCE]." + this.quoteIdentifier((String)fieldName)).collect(Collectors.joining(", "));
        String upsertSQL = String.format("MERGE INTO %s.%s AS [TARGET] USING (%s) AS [SOURCE] ON (%s) WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s);", this.quoteDatabaseIdentifier(database), this.quoteIdentifier(tableName), usingClause, onConditions, updateSetClause, insertFields, insertValues);
        return Optional.of(upsertSQL);
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("[").append(parts[i]).append("]").append(".");
            }
            return sb.append("[").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("]").toString();
        }
        return "[" + this.getFieldIde(identifier, this.fieldIde) + "]";
    }

    @Override
    public String quoteDatabaseIdentifier(String identifier) {
        return "[" + identifier + "]";
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getFullName());
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public Long approximateRowCntStatement(Connection connection, JdbcSourceTable table) throws SQLException {
        boolean useTableStats;
        boolean bl = useTableStats = StringUtils.isBlank(table.getQuery()) || !table.getQuery().toLowerCase().contains("where") && table.getTablePath() != null && !TablePath.DEFAULT.getFullName().equals(table.getTablePath().getFullName());
        if (useTableStats) {
            TablePath tablePath = table.getTablePath();
            try (Statement stmt = connection.createStatement();){
                Long l;
                block15: {
                    if (StringUtils.isNotBlank(tablePath.getDatabaseName())) {
                        String useDatabaseStatement = String.format("USE %s;", this.quoteDatabaseIdentifier(tablePath.getDatabaseName()));
                        log.info("Split Chunk, approximateRowCntStatement: {}", (Object)useDatabaseStatement);
                        stmt.execute(useDatabaseStatement);
                    }
                    String rowCountQuery = String.format("SELECT Total_Rows = SUM(st.row_count) FROM sys.dm_db_partition_stats st WHERE object_name(object_id) = '%s' AND index_id < 2;", tablePath.getTableName());
                    log.info("Split Chunk, approximateRowCntStatement: {}", (Object)rowCountQuery);
                    ResultSet rs = stmt.executeQuery(rowCountQuery);
                    try {
                        if (!rs.next()) {
                            throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
                        }
                        l = rs.getLong(1);
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return l;
            }
        }
        return SQLUtils.countForSubquery(connection, table.getQuery());
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT TOP (%s) %s FROM (%s) AS T1 WHERE %s >= ? ORDER BY %s ASC) AS T2", quotedColumn, chunkSize, quotedColumn, table.getQuery(), quotedColumn, quotedColumn) : String.format("SELECT MAX(%s) FROM (SELECT TOP (%s) %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) AS T", quotedColumn, chunkSize, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            ps.setObject(1, includedLowerBound);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return object;
                }
                throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
            }
        }
    }
}

