/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.hive;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTypeMapper.class);
    private static final String HIVE_TINYINT = "TINYINT";
    private static final String HIVE_SMALLINT = "SMALLINT";
    private static final String HIVE_INT = "INT";
    private static final String HIVE_INTEGER = "INTEGER";
    private static final String HIVE_BIGINT = "BIGINT";
    private static final String HIVE_FLOAT = "FLOAT";
    private static final String HIVE_DOUBLE = "DOUBLE";
    private static final String HIVE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String HIVE_DECIMAL = "DECIMAL";
    private static final String HIVE_NUMERIC = "NUMERIC";
    private static final String HIVE_TIMESTAMP = "TIMESTAMP";
    private static final String HIVE_DATE = "DATE";
    private static final String HIVE_INTERVAL = "INTERVAL";
    private static final String HIVE_STRING = "STRING";
    private static final String HIVE_VARCHAR = "VARCHAR";
    private static final String HIVE_CHAR = "CHAR";
    private static final String HIVE_BOOLEAN = "BOOLEAN";
    private static final String HIVE_BINARY = "BINARY";
    private static final String HIVE_ARRAY = "ARRAY";
    private static final String HIVE_MAP = "MAP";
    private static final String HIVE_STRUCT = "STRUCT";
    private static final String HIVE_UNIONTYPE = "UNIONTYPE";

    @Override
    public SeaTunnelDataType<?> mapping(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnType = metadata.getColumnTypeName(colIndex).toUpperCase();
        int precision = metadata.getPrecision(colIndex);
        switch (columnType) {
            case "TINYINT": {
                return BasicType.BYTE_TYPE;
            }
            case "SMALLINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INT": 
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": {
                return BasicType.DOUBLE_TYPE;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                if (precision > 0) {
                    return new DecimalType(precision, metadata.getScale(colIndex));
                }
                LOG.warn("decimal did define precision,scale, will be Decimal(38,18)");
                return new DecimalType(38, 18);
            }
            case "TIMESTAMP": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "STRING": 
            case "VARCHAR": 
            case "CHAR": {
                return BasicType.STRING_TYPE;
            }
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw CommonError.convertToSeaTunnelTypeError((String)"HIVE", (String)columnType, (String)jdbcColumnName);
    }
}

