/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection;

import com.google.common.base.CaseFormat;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;

public class DataSourceUtils
implements Serializable {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    public static CommonDataSource buildCommonDataSource(@NonNull JdbcConnectionConfig jdbcConnectionConfig) throws InvocationTargetException, IllegalAccessException {
        if (jdbcConnectionConfig == null) {
            throw new NullPointerException("jdbcConnectionConfig is marked non-null but is null");
        }
        CommonDataSource dataSource = (CommonDataSource)DataSourceUtils.loadDataSource(jdbcConnectionConfig.getXaDataSourceClassName());
        DataSourceUtils.setProperties(dataSource, DataSourceUtils.buildDatabaseAccessConfig(jdbcConnectionConfig));
        return dataSource;
    }

    private static Map<String, Object> buildDatabaseAccessConfig(JdbcConnectionConfig jdbcConnectionConfig) {
        HashMap<String, Object> accessConfig = new HashMap<String, Object>();
        accessConfig.put("url", jdbcConnectionConfig.getUrl());
        if (jdbcConnectionConfig.getUsername().isPresent()) {
            accessConfig.put("user", jdbcConnectionConfig.getUsername().get());
        }
        if (jdbcConnectionConfig.getPassword().isPresent()) {
            accessConfig.put("password", jdbcConnectionConfig.getPassword().get());
        }
        accessConfig.putAll(jdbcConnectionConfig.getProperties());
        return accessConfig;
    }

    private static void setProperties(CommonDataSource commonDataSource, Map<String, Object> databaseAccessConfig) throws InvocationTargetException, IllegalAccessException {
        for (Map.Entry<String, Object> entry : databaseAccessConfig.entrySet()) {
            Object value;
            Optional<Method> method = DataSourceUtils.findSetterMethod(commonDataSource.getClass().getMethods(), entry.getKey());
            if (!method.isPresent()) continue;
            Method setterMethod = method.get();
            Class<?> parameterType = setterMethod.getParameterTypes()[0];
            if (!parameterType.isInstance(value = entry.getValue())) {
                value = DataSourceUtils.convertType(value, parameterType);
            }
            method.get().invoke((Object)commonDataSource, value);
        }
    }

    private static Object convertType(Object value, Class<?> targetType) {
        if (targetType.isInstance(value)) {
            return value;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.parseLong(value.toString());
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.parseBoolean(value.toString());
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.parseDouble(value.toString());
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (targetType == String.class) {
            return value.toString();
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + targetType);
    }

    private static Method findGetterMethod(DataSource dataSource, String propertyName) throws NoSuchMethodException {
        String getterMethodName = GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName);
        Method result = dataSource.getClass().getMethod(getterMethodName, new Class[0]);
        result.setAccessible(true);
        return result;
    }

    private static Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property);
        Optional<Method> methodOptional = Arrays.stream(methods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
        if (!methodOptional.isPresent()) {
            methodOptional = Arrays.stream(methods).filter(each -> each.getName().equalsIgnoreCase(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
        }
        return methodOptional;
    }

    private static Object loadDataSource(String xaDataSourceClassName) {
        Class<?> xaDataSourceClass;
        try {
            xaDataSourceClass = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                xaDataSourceClass = Class.forName(xaDataSourceClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.CLASS_NOT_FOUND, "Failed to load [" + xaDataSourceClassName + "]", ex);
            }
        }
        try {
            return xaDataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.REFLECT_CLASS_OPERATION_FAILED, "Failed to instance [" + xaDataSourceClassName + "]", ex);
        }
    }
}

