/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.sqlserver.utils;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.utils.CatalogTableUtils;

public class SqlServerSchema {
    private final SqlServerConnectorConfig connectorConfig;
    private final Map<TableId, TableChanges.TableChange> schemasByTableId = new ConcurrentHashMap<TableId, TableChanges.TableChange>();
    private final Map<TableId, CatalogTable> tableMap;

    public SqlServerSchema(SqlServerConnectorConfig connectorConfig, Map<TableId, CatalogTable> tableMap) {
        this.connectorConfig = connectorConfig;
        this.tableMap = tableMap;
    }

    public TableChanges.TableChange getTableSchema(JdbcConnection jdbc, TableId tableId) {
        TableChanges.TableChange schema = this.schemasByTableId.get(tableId);
        if (schema == null) {
            schema = this.readTableSchema(jdbc, tableId);
        }
        return schema;
    }

    private TableChanges.TableChange readTableSchema(JdbcConnection jdbc, TableId tableId) {
        SqlServerConnection sqlServerConnection = (SqlServerConnection)jdbc;
        Tables tables = new Tables();
        try {
            sqlServerConnection.readSchema(tables, tableId.catalog(), tableId.schema(), this.connectorConfig.getTableFilters().dataCollectionFilter(), null, false);
            for (TableId id : tables.tableIds()) {
                if (!this.tableMap.containsKey(id)) continue;
                Table table = CatalogTableUtils.mergeCatalogTableConfig(tables.forTable(id), this.tableMap.get(id));
                TableChanges.TableChange tableChange = new TableChanges.TableChange(TableChanges.TableChangeType.CREATE, table);
                this.schemasByTableId.put(id, tableChange);
            }
        }
        catch (SQLException e) {
            throw new SeaTunnelException(String.format("Failed to read schema for table %s ", tableId), (Throwable)e);
        }
        if (!this.schemasByTableId.containsKey(tableId)) {
            throw new SeaTunnelException(String.format("Can't obtain schema for table %s ", tableId));
        }
        return this.schemasByTableId.get(tableId);
    }
}

