/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure.extend;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang.ArrayUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.core.rpc.ShutdownHook;
import org.apache.seata.core.rpc.netty.RmNettyRemotingClient;
import org.apache.seata.core.rpc.netty.TmNettyRemotingClient;
import org.apache.seata.integration.tx.api.interceptor.SeataInterceptor;
import org.apache.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.DefaultInterfaceParser;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.NeedEnhanceEnum;
import org.apache.seata.integration.tx.api.remoting.RemotingParser;
import org.apache.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import org.apache.seata.rm.RMClient;
import org.apache.seata.spring.annotation.AdapterSpringSeataInterceptor;
import org.apache.seata.spring.annotation.GlobalTransactional;
import org.apache.seata.spring.annotation.MethodDesc;
import org.apache.seata.spring.annotation.ScannerChecker;
import org.apache.seata.spring.annotation.scannercheckers.PackageScannerChecker;
import org.apache.seata.spring.remoting.parser.RemotingFactoryBeanParser;
import org.apache.seata.spring.util.OrderUtil;
import org.apache.seata.spring.util.SpringProxyUtils;
import org.apache.seata.tm.TMClient;
import org.apache.seata.tm.api.FailureHandler;
import org.apache.seata.tm.api.FailureHandlerHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class HussarGlobalTransactionScanner
extends AbstractAutoProxyCreator
implements CachedConfigurationChangeListener,
InitializingBean,
ApplicationContextAware,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarGlobalTransactionScanner.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private static final String SPRING_TRANSACTION_INTERCEPTOR_CLASS_NAME = "org.springframework.transaction.interceptor.TransactionInterceptor";
    private static final Set<String> PROXYED_SET = new HashSet<String>();
    private static final Set<String> EXCLUDE_BEAN_NAME_SET = new HashSet<String>();
    private static final Set<ScannerChecker> SCANNER_CHECKER_SET = new LinkedHashSet<ScannerChecker>();
    private static ConfigurableListableBeanFactory beanFactory;
    private MethodInterceptor interceptor;
    private final String applicationId;
    private final String txServiceGroup;
    private static String accessKey;
    private static String secretKey;
    private volatile boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final FailureHandler failureHandlerHook;
    private ApplicationContext applicationContext;
    private static final Set<String> NEED_ENHANCE_BEAN_NAME_SET;
    private static final Set<String> IGNORE_ENHANCE_CHECK_SET;

    public HussarGlobalTransactionScanner(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public HussarGlobalTransactionScanner(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public HussarGlobalTransactionScanner(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public HussarGlobalTransactionScanner(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, false, null);
    }

    public HussarGlobalTransactionScanner(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, false, failureHandlerHook);
    }

    public HussarGlobalTransactionScanner(String applicationId, String txServiceGroup, boolean exposeProxy, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, exposeProxy, failureHandlerHook);
    }

    public HussarGlobalTransactionScanner(String applicationId, String txServiceGroup, int mode, boolean exposeProxy, FailureHandler failureHandlerHook) {
        this.setOrder(1024);
        this.setProxyTargetClass(true);
        this.setExposeProxy(exposeProxy);
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.failureHandlerHook = failureHandlerHook;
        FailureHandlerHolder.setFailureHandler((FailureHandler)this.failureHandlerHook);
    }

    public static void setAccessKey(String accessKey) {
        HussarGlobalTransactionScanner.accessKey = accessKey;
    }

    public static void setSecretKey(String secretKey) {
        HussarGlobalTransactionScanner.secretKey = secretKey;
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    protected void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if ("my_test_tx_group".equals(this.txServiceGroup)) {
            LOGGER.warn("the default value of seata.tx-service-group: {} has already changed to {} since Seata 1.5, please change your default configuration as soon as possible and we don't recommend you to use default tx-service-group's value provided by seata", (Object)"my_test_tx_group", (Object)"default_tx_group");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException(String.format("applicationId: %s, txServiceGroup: %s", this.applicationId, this.txServiceGroup));
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup, (String)accessKey, (String)secretKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    protected void registerSpringShutdownHook() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            ShutdownHook.removeRuntimeShutdownHook();
        }
        ShutdownHook.getInstance().addDisposable((Disposable)TmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup, (String)accessKey, (String)secretKey));
        ShutdownHook.getInstance().addDisposable((Disposable)RmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (!this.doCheckers(bean, beanName)) {
            return bean;
        }
        try {
            Set<String> set = PROXYED_SET;
            synchronized (set) {
                if (PROXYED_SET.contains(beanName)) {
                    return bean;
                }
                if (!NEED_ENHANCE_BEAN_NAME_SET.contains(beanName)) {
                    return bean;
                }
                this.interceptor = null;
                ProxyInvocationHandler proxyInvocationHandler = DefaultInterfaceParser.get().parserInterfaceToProxy(bean, beanName);
                if (proxyInvocationHandler == null) {
                    return bean;
                }
                this.interceptor = new AdapterSpringSeataInterceptor(proxyInvocationHandler);
                LOGGER.info("Bean [{}] with name [{}] would use interceptor [{}]", new Object[]{bean.getClass().getName(), beanName, this.interceptor.toString()});
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport((Object)bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        int pos = this.findAddSeataAdvisorPosition(advised, avr);
                        advised.addAdvisor(pos, avr);
                    }
                }
                PROXYED_SET.add(beanName);
                return bean;
            }
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private boolean doCheckers(Object bean, String beanName) {
        if (PROXYED_SET.contains(beanName) || EXCLUDE_BEAN_NAME_SET.contains(beanName) || FactoryBean.class.isAssignableFrom(bean.getClass())) {
            return false;
        }
        if (!SCANNER_CHECKER_SET.isEmpty()) {
            for (ScannerChecker checker : SCANNER_CHECKER_SET) {
                try {
                    if (checker.check(bean, beanName, beanFactory)) continue;
                    return false;
                }
                catch (Exception e) {
                    LOGGER.error("Do check failed: beanName={}, checker={}", new Object[]{beanName, checker.getClass().getSimpleName(), e});
                }
            }
        }
        return true;
    }

    private int findAddSeataAdvisorPosition(AdvisedSupport advised, Advisor seataAdvisor) {
        int seataOrder = OrderUtil.getOrder((Object)seataAdvisor);
        SeataInterceptorPosition seataInterceptorPosition = this.getSeataInterceptorPosition(seataAdvisor);
        if (SeataInterceptorPosition.Any == seataInterceptorPosition) {
            if (seataOrder == Integer.MAX_VALUE) {
                return advised.getAdvisors().length;
            }
            if (seataOrder == Integer.MIN_VALUE) {
                return 0;
            }
        } else {
            Integer position = this.computePositionIfHasTransactionInterceptor(advised, seataAdvisor, seataInterceptorPosition, seataOrder);
            if (position != null) {
                return position;
            }
        }
        return this.findPositionInAdvisors(advised.getAdvisors(), seataAdvisor);
    }

    @Nullable
    private Integer computePositionIfHasTransactionInterceptor(AdvisedSupport advised, Advisor seataAdvisor, SeataInterceptorPosition seataInterceptorPosition, int seataOrder) {
        int newSeataOrder;
        Advisor otherAdvisor = null;
        Integer transactionInterceptorPosition = null;
        Integer transactionInterceptorOrder = null;
        int l = advised.getAdvisors().length;
        for (int i = 0; i < l; ++i) {
            otherAdvisor = advised.getAdvisors()[i];
            if (!this.isTransactionInterceptor(otherAdvisor)) continue;
            transactionInterceptorPosition = i;
            transactionInterceptorOrder = OrderUtil.getOrder((Object)otherAdvisor);
            break;
        }
        if (transactionInterceptorPosition == null) {
            return null;
        }
        Advice seataAdvice = seataAdvisor.getAdvice();
        if (SeataInterceptorPosition.AfterTransaction == seataInterceptorPosition && OrderUtil.higherOrEquals((Integer)seataOrder, transactionInterceptorOrder)) {
            newSeataOrder = OrderUtil.lower((Integer)transactionInterceptorOrder, (int)1);
            ((SeataInterceptor)seataAdvice).setOrder(newSeataOrder);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The {}'s order '{}' is higher or equals than {}'s order '{}' , reset {}'s order to lower order '{}'.", new Object[]{seataAdvice.getClass().getSimpleName(), seataOrder, otherAdvisor.getAdvice().getClass().getSimpleName(), transactionInterceptorOrder, seataAdvice.getClass().getSimpleName(), newSeataOrder});
            }
            return transactionInterceptorPosition + 1;
        }
        if (SeataInterceptorPosition.BeforeTransaction == seataInterceptorPosition && OrderUtil.lowerOrEquals((Integer)seataOrder, transactionInterceptorOrder)) {
            newSeataOrder = OrderUtil.higher((Integer)transactionInterceptorOrder, (int)1);
            ((SeataInterceptor)seataAdvice).setOrder(newSeataOrder);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The {}'s order '{}' is lower or equals than {}'s order '{}' , reset {}'s order to higher order '{}'.", new Object[]{seataAdvice.getClass().getSimpleName(), seataOrder, otherAdvisor.getAdvice().getClass().getSimpleName(), transactionInterceptorOrder, seataAdvice.getClass().getSimpleName(), newSeataOrder});
            }
            return transactionInterceptorPosition;
        }
        return null;
    }

    private int findPositionInAdvisors(Advisor[] advisors, Advisor seataAdvisor) {
        int l = advisors.length;
        for (int i = 0; i < l; ++i) {
            Advisor advisor = advisors[i];
            if (!OrderUtil.higherOrEquals((Advisor)seataAdvisor, (Advisor)advisor)) continue;
            return i;
        }
        return advisors.length;
    }

    private SeataInterceptorPosition getSeataInterceptorPosition(Advisor seataAdvisor) {
        Advice seataAdvice = seataAdvisor.getAdvice();
        if (seataAdvice instanceof SeataInterceptor) {
            return ((SeataInterceptor)seataAdvice).getPosition();
        }
        return SeataInterceptorPosition.Any;
    }

    private boolean isTransactionInterceptor(Advisor advisor) {
        return SPRING_TRANSACTION_INTERCEPTOR_CLASS_NAME.equals(advisor.getAdvice().getClass().getName());
    }

    private MethodDesc makeMethodDesc(GlobalTransactional anno, Method method) {
        return new MethodDesc(anno, method);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void afterPropertiesSet() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            ConfigurationFactory.getInstance().addConfigListener("service.disableGlobalTransaction", (ConfigurationChangeListener)this);
            return;
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.initClient();
        }
        this.findBusinessBeanNamesNeededEnhancement();
    }

    private void findBusinessBeanNamesNeededEnhancement() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            String[] beanNames;
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
            ConfigurableListableBeanFactory configurableListableBeanFactory = configurableApplicationContext.getBeanFactory();
            for (String contextBeanName : beanNames = this.applicationContext.getBeanDefinitionNames()) {
                BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(contextBeanName);
                if (StringUtils.isBlank((String)beanDefinition.getBeanClassName()) || IGNORE_ENHANCE_CHECK_SET.contains(beanDefinition.getBeanClassName())) continue;
                try {
                    Class<?> beanClass = Class.forName(beanDefinition.getBeanClassName());
                    IfNeedEnhanceBean ifNeedEnhanceBean = DefaultInterfaceParser.get().parseIfNeedEnhancement(beanClass);
                    if (!ifNeedEnhanceBean.isIfNeed()) continue;
                    if (ifNeedEnhanceBean.getNeedEnhanceEnum().equals((Object)NeedEnhanceEnum.SERVICE_BEAN)) {
                        RuntimeBeanReference r;
                        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue("ref");
                        if (propertyValue == null) {
                            propertyValue = beanDefinition.getPropertyValues().getPropertyValue("target");
                        }
                        if (propertyValue != null && (r = (RuntimeBeanReference)propertyValue.getValue()) != null && StringUtils.isNotBlank((String)r.getBeanName())) {
                            NEED_ENHANCE_BEAN_NAME_SET.add(r.getBeanName());
                            continue;
                        }
                        NEED_ENHANCE_BEAN_NAME_SET.add(contextBeanName);
                        continue;
                    }
                    if (!ifNeedEnhanceBean.getNeedEnhanceEnum().equals((Object)NeedEnhanceEnum.GLOBAL_TRANSACTIONAL_BEAN)) continue;
                    NEED_ENHANCE_BEAN_NAME_SET.add(contextBeanName);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("check if need enhance bean error, it can be ignore", (Throwable)e);
                }
            }
            LOGGER.info("The needed enhancement business beans are : {}", NEED_ENHANCE_BEAN_NAME_SET);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        RemotingFactoryBeanParser remotingFactoryBeanParser = new RemotingFactoryBeanParser(applicationContext);
        DefaultRemotingParser.get().registerRemotingParser((RemotingParser)remotingFactoryBeanParser);
        this.setBeanFactory((BeanFactory)applicationContext);
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            this.disableGlobalTransaction = Boolean.parseBoolean(event.getNewValue().trim());
            if (!this.disableGlobalTransaction && this.initialized.compareAndSet(false, true)) {
                LOGGER.info("{} config changed, old value:true, new value:{}", (Object)"service.disableGlobalTransaction", (Object)event.getNewValue());
                this.initClient();
                ConfigurationFactory.getInstance().removeConfigListener("service.disableGlobalTransaction", (ConfigurationChangeListener)this);
            }
        }
    }

    public static void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        HussarGlobalTransactionScanner.beanFactory = beanFactory;
    }

    public static void addScannablePackages(String ... packages) {
        PackageScannerChecker.addScannablePackages((String[])packages);
    }

    public static void addScannerCheckers(Collection<ScannerChecker> scannerCheckers) {
        if (CollectionUtils.isNotEmpty(scannerCheckers)) {
            scannerCheckers.remove(null);
            SCANNER_CHECKER_SET.addAll(scannerCheckers);
        }
    }

    public static void addScannerCheckers(ScannerChecker ... scannerCheckers) {
        if (ArrayUtils.isNotEmpty((Object[])scannerCheckers)) {
            HussarGlobalTransactionScanner.addScannerCheckers(Arrays.asList(scannerCheckers));
        }
    }

    public static void addScannerExcludeBeanNames(String ... beanNames) {
        if (ArrayUtils.isNotEmpty((Object[])beanNames)) {
            EXCLUDE_BEAN_NAME_SET.addAll(Arrays.asList(beanNames));
        }
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getTxServiceGroup() {
        return this.txServiceGroup;
    }

    public static String getAccessKey() {
        return accessKey;
    }

    public static String getSecretKey() {
        return secretKey;
    }

    static {
        NEED_ENHANCE_BEAN_NAME_SET = new HashSet<String>();
        IGNORE_ENHANCE_CHECK_SET = ImmutableSet.of((Object)"org.apache.seata.spring.annotation.GlobalTransactionScanner", (Object)"org.apache.seata.spring.boot.autoconfigure.extend.HussarGlobalTransactionScanner", (Object)"org.apache.seata.rm.fence.SpringFenceConfig", (Object)"org.springframework.context.annotation.internalConfigurationAnnotationProcessor", (Object)"org.springframework.context.annotation.internalAutowiredAnnotationProcessor", (Object)"org.springframework.context.annotation.internalCommonAnnotationProcessor", (Object[])new String[]{"org.springframework.context.event.internalEventListenerProcessor", "org.springframework.context.event.internalEventListenerFactory"});
    }
}

