/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure;

import javax.sql.DataSource;
import org.apache.seata.spring.annotation.datasource.SeataAutoDataSourceProxyCreator;
import org.apache.seata.spring.boot.autoconfigure.HussarSeataCoreAutoConfiguration;
import org.apache.seata.spring.boot.autoconfigure.properties.SeataProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnBean(value={DataSource.class})
@ConditionalOnExpression(value="${seata.enabled:true} && ${seata.enableAutoDataSourceProxy:true} && ${seata.enable-auto-data-source-proxy:true}")
@AutoConfigureOrder(value=0x7FFFFFFF)
@AutoConfigureAfter(value={HussarSeataCoreAutoConfiguration.class}, name={"org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration"})
public class SeataDataSourceAutoConfiguration {
    @Bean(value={"seataAutoDataSourceProxyCreator"})
    @ConditionalOnMissingBean(value={SeataAutoDataSourceProxyCreator.class})
    public static SeataAutoDataSourceProxyCreator seataAutoDataSourceProxyCreator(SeataProperties seataProperties) {
        return new SeataAutoDataSourceProxyCreator(seataProperties.isUseJdkProxy(), seataProperties.getExcludesForAutoProxying(), seataProperties.getDataSourceProxyMode());
    }
}

