/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure;

import java.util.List;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.spring.annotation.GlobalTransactionScanner;
import org.apache.seata.spring.annotation.ScannerChecker;
import org.apache.seata.spring.boot.autoconfigure.HussarSeataCoreAutoConfiguration;
import org.apache.seata.spring.boot.autoconfigure.extend.HussarGlobalTransactionScanner;
import org.apache.seata.spring.boot.autoconfigure.properties.SeataProperties;
import org.apache.seata.tm.api.DefaultFailureHandlerImpl;
import org.apache.seata.tm.api.FailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@AutoConfigureAfter(value={HussarSeataCoreAutoConfiguration.class})
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider", "failureHandler", "springContextHolder"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public static HussarGlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler, ConfigurableListableBeanFactory beanFactory, @Autowired(required=false) List<ScannerChecker> scannerCheckers) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        HussarGlobalTransactionScanner.setBeanFactory(beanFactory);
        HussarGlobalTransactionScanner.addScannerCheckers(EnhancedServiceLoader.loadAll(ScannerChecker.class));
        HussarGlobalTransactionScanner.addScannerCheckers(scannerCheckers);
        HussarGlobalTransactionScanner.addScannablePackages(seataProperties.getScanPackages());
        HussarGlobalTransactionScanner.addScannerExcludeBeanNames(seataProperties.getExcludesForScanning());
        HussarGlobalTransactionScanner.setAccessKey(seataProperties.getAccessKey());
        HussarGlobalTransactionScanner.setSecretKey(seataProperties.getSecretKey());
        return new HussarGlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), seataProperties.isExposeProxy(), failureHandler);
    }
}

