/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.tcc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.seata.integration.tx.api.remoting.RemotingDesc;
import org.apache.seata.integration.tx.api.util.ProxyUtil;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class TccAnnotationProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccAnnotationProcessor.class);
    private static final List<Class<? extends Annotation>> ANNOTATIONS = new ArrayList<Class<? extends Annotation>>(4);
    private static final Set<String> PROXIED_SET = new HashSet<String>();

    private static Class<? extends Annotation> loadAnnotation(String annotation) {
        try {
            return Class.forName(annotation);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected void process(Object bean, String beanName, Class<? extends Annotation> annotation) {
        if (Objects.isNull(annotation) || PROXIED_SET.contains(beanName)) {
            return;
        }
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            Object reference = field.getAnnotation(annotation);
            if (reference == null) {
                return;
            }
            this.addTccAdvise(bean, beanName, field, field.getType());
        }, field -> !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(annotation));
        PROXIED_SET.add(beanName);
    }

    public void addTccAdvise(Object bean, String beanName, Field field, Class serviceClass) throws IllegalAccessException {
        Object fieldValue = field.get(bean);
        if (fieldValue == null) {
            return;
        }
        for (Method method : field.getType().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(TwoPhaseBusinessAction.class)) continue;
            RemotingDesc remotingDesc = new RemotingDesc();
            remotingDesc.setServiceClass(serviceClass);
            Object proxyBean = ProxyUtil.createProxy(bean, beanName);
            field.setAccessible(true);
            field.set(bean, proxyBean);
            LOGGER.info("Bean[" + bean.getClass().getName() + "] with name [" + field.getName() + "] would use proxy");
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for (Class<? extends Annotation> annotation : ANNOTATIONS) {
            this.process(bean, beanName, annotation);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    static {
        ANNOTATIONS.add(TccAnnotationProcessor.loadAnnotation("org.apache.dubbo.config.annotation.Reference"));
        ANNOTATIONS.add(TccAnnotationProcessor.loadAnnotation("com.alipay.sofa.runtime.api.annotation.SofaReference"));
    }
}

