/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.pcext.InterceptableStateHandler;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateHandlerInterceptor;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.proctrl.HierarchicalProcessContext;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.statelang.domain.impl.ScriptTaskStateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskStateHandler
implements StateHandler,
InterceptableStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskStateHandler.class);
    private List<StateHandlerInterceptor> interceptors = new ArrayList<StateHandlerInterceptor>();
    private volatile Map<String, ScriptEngine> scriptEngineCache = new ConcurrentHashMap<String, ScriptEngine>();

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        ScriptTaskStateImpl state = (ScriptTaskStateImpl)instruction.getState(context);
        String scriptType = state.getScriptType();
        String scriptContent = state.getScriptContent();
        try {
            Map inputExpMap;
            List<Object> inputExps;
            StateMachineConfig stateMachineConfig;
            ScriptEngine scriptEngine;
            List input = (List)context.getVariable("inputParams");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(">>>>>>>>>>>>>>>>>>>>>> Start to execute ScriptTaskState[{}], ScriptType[{}], Input:{}", new Object[]{state.getName(), scriptType, input});
            }
            if ((scriptEngine = this.getScriptEngineFromCache(scriptType, (stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_")).getScriptEngineManager())) == null) {
                throw new EngineExecutionException("No such ScriptType[" + scriptType + "]", FrameworkErrorCode.ObjectNotExists);
            }
            SimpleBindings bindings = null;
            Map inputMap = null;
            if (CollectionUtils.isNotEmpty(input) && input.get(0) instanceof Map) {
                inputMap = (Map)input.get(0);
            }
            if (CollectionUtils.isNotEmpty(inputExps = state.getInput()) && inputExps.get(0) instanceof Map && (inputExpMap = (Map)inputExps.get(0)).size() > 0) {
                bindings = new SimpleBindings();
                for (String property : inputExpMap.keySet()) {
                    if (inputMap != null && inputMap.containsKey(property)) {
                        bindings.put(property, inputMap.get(property));
                        continue;
                    }
                    bindings.put(property, (Object)null);
                }
            }
            Object result = bindings != null ? scriptEngine.eval(scriptContent, bindings) : scriptEngine.eval(scriptContent);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("<<<<<<<<<<<<<<<<<<<<<< ScriptTaskState[{}], ScriptType[{}], Execute finish. result: {}", new Object[]{state.getName(), scriptType, result});
            }
            if (result != null) {
                ((HierarchicalProcessContext)context).setVariableLocally("outputParams", result);
            }
        }
        catch (Throwable e) {
            LOGGER.error("<<<<<<<<<<<<<<<<<<<<<< ScriptTaskState[{}], ScriptTaskState[{}] Execute failed.", new Object[]{state.getName(), scriptType, e});
            ((HierarchicalProcessContext)context).setVariableLocally("currentException", e);
            EngineUtils.handleException(context, state, e);
        }
    }

    protected ScriptEngine getScriptEngineFromCache(String scriptType, ScriptEngineManager scriptEngineManager) {
        return CollectionUtils.computeIfAbsent(this.scriptEngineCache, scriptType, key -> scriptEngineManager.getEngineByName(scriptType));
    }

    @Override
    public List<StateHandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(StateHandlerInterceptor interceptor) {
        if (this.interceptors != null && !this.interceptors.contains(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    public void setInterceptors(List<StateHandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

