/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.pcext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.pcext.InterceptableStateRouter;
import org.apache.seata.saga.engine.pcext.StateInstruction;
import org.apache.seata.saga.engine.pcext.StateRouter;
import org.apache.seata.saga.engine.pcext.StateRouterInterceptor;
import org.apache.seata.saga.engine.pcext.routers.EndStateRouter;
import org.apache.seata.saga.engine.pcext.routers.TaskStateRouter;
import org.apache.seata.saga.engine.pcext.utils.EngineUtils;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.ProcessRouter;
import org.apache.seata.saga.statelang.domain.State;
import org.apache.seata.saga.statelang.domain.StateMachine;

public class StateMachineProcessRouter
implements ProcessRouter {
    private final Map<String, StateRouter> stateRouters = new ConcurrentHashMap<String, StateRouter>();

    @Override
    public Instruction route(ProcessContext context) throws FrameworkException {
        State state;
        StateInstruction stateInstruction = context.getInstruction(StateInstruction.class);
        if (stateInstruction.getTemporaryState() != null) {
            state = stateInstruction.getTemporaryState();
            stateInstruction.setTemporaryState(null);
        } else {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            StateMachine stateMachine = stateMachineConfig.getStateMachineRepository().getStateMachine(stateInstruction.getStateMachineName(), stateInstruction.getTenantId());
            state = stateMachine.getStates().get(stateInstruction.getStateName());
        }
        String stateType = state.getType();
        StateRouter router = this.stateRouters.get(stateType);
        Instruction instruction = null;
        List<StateRouterInterceptor> interceptors = null;
        if (router instanceof InterceptableStateRouter) {
            interceptors = ((InterceptableStateRouter)router).getInterceptors();
        }
        ArrayList<StateRouterInterceptor> executedInterceptors = null;
        Exception exception = null;
        try {
            if (CollectionUtils.isNotEmpty(interceptors)) {
                executedInterceptors = new ArrayList<StateRouterInterceptor>(interceptors.size());
                for (StateRouterInterceptor interceptor : interceptors) {
                    executedInterceptors.add(interceptor);
                    interceptor.preRoute(context, state);
                }
            }
            instruction = router.route(context, state);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(executedInterceptors)) {
                for (int i = executedInterceptors.size() - 1; i >= 0; --i) {
                    StateRouterInterceptor interceptor = (StateRouterInterceptor)executedInterceptors.get(i);
                    interceptor.postRoute(context, state, instruction, exception);
                }
            }
            if (instruction == null && !stateInstruction.isEnd()) {
                EngineUtils.endStateMachine(context);
            }
        }
        return instruction;
    }

    public void initDefaultStateRouters() {
        if (this.stateRouters.isEmpty()) {
            TaskStateRouter taskStateRouter = new TaskStateRouter();
            this.stateRouters.put("ServiceTask", taskStateRouter);
            this.stateRouters.put("ScriptTask", taskStateRouter);
            this.stateRouters.put("Choice", taskStateRouter);
            this.stateRouters.put("CompensationTrigger", taskStateRouter);
            this.stateRouters.put("SubStateMachine", taskStateRouter);
            this.stateRouters.put("CompensateSubMachine", taskStateRouter);
            this.stateRouters.put("LoopStart", taskStateRouter);
            this.stateRouters.put("Succeed", new EndStateRouter());
            this.stateRouters.put("Fail", new EndStateRouter());
        }
    }

    public Map<String, StateRouter> getStateRouters() {
        return this.stateRouters;
    }

    public void setStateRouters(Map<String, StateRouter> stateRouters) {
        this.stateRouters.putAll(stateRouters);
    }
}

