/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.config;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.script.ScriptEngineManager;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.saga.engine.StateMachineConfig;
import org.apache.seata.saga.engine.expression.ExpressionFactoryManager;
import org.apache.seata.saga.engine.expression.ExpressionResolver;
import org.apache.seata.saga.engine.expression.exception.ExceptionMatchExpressionFactory;
import org.apache.seata.saga.engine.expression.impl.DefaultExpressionResolver;
import org.apache.seata.saga.engine.expression.seq.SequenceExpressionFactory;
import org.apache.seata.saga.engine.invoker.ServiceInvokerManager;
import org.apache.seata.saga.engine.pcext.InterceptableStateHandler;
import org.apache.seata.saga.engine.pcext.InterceptableStateRouter;
import org.apache.seata.saga.engine.pcext.StateHandler;
import org.apache.seata.saga.engine.pcext.StateHandlerInterceptor;
import org.apache.seata.saga.engine.pcext.StateMachineProcessHandler;
import org.apache.seata.saga.engine.pcext.StateMachineProcessRouter;
import org.apache.seata.saga.engine.pcext.StateRouter;
import org.apache.seata.saga.engine.pcext.StateRouterInterceptor;
import org.apache.seata.saga.engine.repo.StateLogRepository;
import org.apache.seata.saga.engine.repo.StateMachineRepository;
import org.apache.seata.saga.engine.repo.impl.StateLogRepositoryImpl;
import org.apache.seata.saga.engine.repo.impl.StateMachineRepositoryImpl;
import org.apache.seata.saga.engine.sequence.SeqGenerator;
import org.apache.seata.saga.engine.sequence.UUIDSeqGenerator;
import org.apache.seata.saga.engine.store.StateLangStore;
import org.apache.seata.saga.engine.store.StateLogStore;
import org.apache.seata.saga.engine.strategy.StatusDecisionStrategy;
import org.apache.seata.saga.engine.strategy.impl.DefaultStatusDecisionStrategy;
import org.apache.seata.saga.proctrl.ProcessRouter;
import org.apache.seata.saga.proctrl.ProcessType;
import org.apache.seata.saga.proctrl.eventing.impl.AsyncEventBus;
import org.apache.seata.saga.proctrl.eventing.impl.DirectEventBus;
import org.apache.seata.saga.proctrl.eventing.impl.ProcessCtrlEventConsumer;
import org.apache.seata.saga.proctrl.eventing.impl.ProcessCtrlEventPublisher;
import org.apache.seata.saga.proctrl.handler.DefaultRouterHandler;
import org.apache.seata.saga.proctrl.handler.ProcessHandler;
import org.apache.seata.saga.proctrl.handler.RouterHandler;
import org.apache.seata.saga.proctrl.impl.ProcessControllerImpl;
import org.apache.seata.saga.proctrl.process.impl.CustomizeBusinessProcessor;

public abstract class AbstractStateMachineConfig
implements StateMachineConfig {
    private static final int DEFAULT_TRANS_OPERATION_TIMEOUT = 1800000;
    private static final int DEFAULT_SERVICE_INVOKE_TIMEOUT = 300000;
    private ExpressionFactoryManager expressionFactoryManager;
    private ExpressionResolver expressionResolver;
    private StateLogRepository stateLogRepository;
    private StateLogStore stateLogStore;
    private StateMachineRepository stateMachineRepository;
    private StateLangStore stateLangStore;
    private StatusDecisionStrategy statusDecisionStrategy;
    private SeqGenerator seqGenerator = new UUIDSeqGenerator();
    private ProcessCtrlEventPublisher syncProcessCtrlEventPublisher;
    private ProcessCtrlEventPublisher asyncProcessCtrlEventPublisher;
    private int transOperationTimeout = 1800000;
    private int serviceInvokeTimeout = 300000;
    private boolean enableAsync = false;
    private ThreadPoolExecutor threadPoolExecutor;
    private ServiceInvokerManager serviceInvokerManager;
    private ScriptEngineManager scriptEngineManager;
    private String charset = "UTF-8";
    private String defaultTenantId = "000001";
    private String sagaJsonParser = "fastjson";
    private boolean autoRegisterResources = true;
    private InputStream[] stateMachineDefInputStreamArray;
    private boolean sagaRetryPersistModeUpdate = false;
    private boolean sagaCompensatePersistModeUpdate = false;
    private boolean rmReportSuccessEnable = false;
    private boolean sagaBranchRegisterEnable = false;

    public void init() throws Exception {
        ProcessCtrlEventConsumer processCtrlEventConsumer;
        ProcessControllerImpl processorController;
        if (this.seqGenerator == null) {
            this.seqGenerator = new UUIDSeqGenerator();
        }
        if (this.expressionFactoryManager == null) {
            this.expressionFactoryManager = new ExpressionFactoryManager();
            SequenceExpressionFactory sequenceExpressionFactory = new SequenceExpressionFactory();
            sequenceExpressionFactory.setSeqGenerator(this.seqGenerator);
            this.expressionFactoryManager.putExpressionFactory("Sequence", sequenceExpressionFactory);
            ExceptionMatchExpressionFactory exceptionMatchExpressionFactory = new ExceptionMatchExpressionFactory();
            this.expressionFactoryManager.putExpressionFactory("Exception", exceptionMatchExpressionFactory);
        }
        if (this.expressionResolver == null) {
            DefaultExpressionResolver defaultExpressionResolver = new DefaultExpressionResolver();
            defaultExpressionResolver.setExpressionFactoryManager(this.expressionFactoryManager);
            this.expressionResolver = defaultExpressionResolver;
        }
        if (this.stateLogRepository == null) {
            StateLogRepositoryImpl defaultStateLogRepository = new StateLogRepositoryImpl();
            defaultStateLogRepository.setStateLogStore(this.stateLogStore);
            this.stateLogRepository = defaultStateLogRepository;
        }
        if (this.stateMachineRepository == null) {
            StateMachineRepositoryImpl defaultStateMachineRepository = new StateMachineRepositoryImpl();
            defaultStateMachineRepository.setCharset(this.charset);
            defaultStateMachineRepository.setSeqGenerator(this.seqGenerator);
            defaultStateMachineRepository.setDefaultTenantId(this.defaultTenantId);
            defaultStateMachineRepository.setJsonParserName(this.sagaJsonParser);
            defaultStateMachineRepository.setStateLangStore(this.stateLangStore);
            this.stateMachineRepository = defaultStateMachineRepository;
        }
        if (this.autoRegisterResources && this.stateMachineDefInputStreamArray != null) {
            this.stateMachineRepository.registryByResources(this.stateMachineDefInputStreamArray, this.defaultTenantId);
        }
        if (this.statusDecisionStrategy == null) {
            this.statusDecisionStrategy = new DefaultStatusDecisionStrategy();
        }
        if (this.syncProcessCtrlEventPublisher == null) {
            ProcessCtrlEventPublisher syncEventPublisher = new ProcessCtrlEventPublisher();
            processorController = this.createProcessorController(syncEventPublisher);
            processCtrlEventConsumer = new ProcessCtrlEventConsumer();
            processCtrlEventConsumer.setProcessController(processorController);
            DirectEventBus directEventBus = new DirectEventBus();
            syncEventPublisher.setEventBus(directEventBus);
            directEventBus.registerEventConsumer(processCtrlEventConsumer);
            this.syncProcessCtrlEventPublisher = syncEventPublisher;
        }
        if (this.enableAsync && this.asyncProcessCtrlEventPublisher == null) {
            ProcessCtrlEventPublisher asyncEventPublisher = new ProcessCtrlEventPublisher();
            processorController = this.createProcessorController(asyncEventPublisher);
            processCtrlEventConsumer = new ProcessCtrlEventConsumer();
            processCtrlEventConsumer.setProcessController(processorController);
            AsyncEventBus asyncEventBus = new AsyncEventBus();
            asyncEventBus.setThreadPoolExecutor(this.getThreadPoolExecutor());
            asyncEventPublisher.setEventBus(asyncEventBus);
            asyncEventBus.registerEventConsumer(processCtrlEventConsumer);
            this.asyncProcessCtrlEventPublisher = asyncEventPublisher;
        }
        if (this.serviceInvokerManager == null) {
            this.serviceInvokerManager = new ServiceInvokerManager();
        }
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
    }

    public ProcessControllerImpl createProcessorController(ProcessCtrlEventPublisher eventPublisher) throws Exception {
        StateMachineProcessRouter stateMachineProcessRouter = new StateMachineProcessRouter();
        stateMachineProcessRouter.initDefaultStateRouters();
        this.loadStateRouterInterceptors(stateMachineProcessRouter.getStateRouters());
        StateMachineProcessHandler stateMachineProcessHandler = new StateMachineProcessHandler();
        stateMachineProcessHandler.initDefaultHandlers();
        this.loadStateHandlerInterceptors(stateMachineProcessHandler.getStateHandlers());
        DefaultRouterHandler defaultRouterHandler = new DefaultRouterHandler();
        defaultRouterHandler.setEventPublisher(eventPublisher);
        HashMap<String, ProcessRouter> processRouterMap = new HashMap<String, ProcessRouter>(1);
        processRouterMap.put(ProcessType.STATE_LANG.getCode(), stateMachineProcessRouter);
        defaultRouterHandler.setProcessRouters(processRouterMap);
        CustomizeBusinessProcessor customizeBusinessProcessor = new CustomizeBusinessProcessor();
        HashMap<String, ProcessHandler> processHandlerMap = new HashMap<String, ProcessHandler>(1);
        processHandlerMap.put(ProcessType.STATE_LANG.getCode(), stateMachineProcessHandler);
        customizeBusinessProcessor.setProcessHandlers(processHandlerMap);
        HashMap<String, RouterHandler> routerHandlerMap = new HashMap<String, RouterHandler>(1);
        routerHandlerMap.put(ProcessType.STATE_LANG.getCode(), defaultRouterHandler);
        customizeBusinessProcessor.setRouterHandlers(routerHandlerMap);
        ProcessControllerImpl processorController = new ProcessControllerImpl();
        processorController.setBusinessProcessor(customizeBusinessProcessor);
        return processorController;
    }

    public void loadStateHandlerInterceptors(Map<String, StateHandler> stateHandlerMap) {
        for (StateHandler stateHandler : stateHandlerMap.values()) {
            if (!(stateHandler instanceof InterceptableStateHandler)) continue;
            InterceptableStateHandler interceptableStateHandler = (InterceptableStateHandler)stateHandler;
            List<StateHandlerInterceptor> interceptorList = EnhancedServiceLoader.loadAll(StateHandlerInterceptor.class);
            for (StateHandlerInterceptor interceptor : interceptorList) {
                if (!interceptor.match(interceptableStateHandler.getClass())) continue;
                interceptableStateHandler.addInterceptor(interceptor);
            }
        }
    }

    public void loadStateRouterInterceptors(Map<String, StateRouter> stateRouterMap) {
        for (StateRouter stateRouter : stateRouterMap.values()) {
            if (!(stateRouter instanceof InterceptableStateRouter)) continue;
            InterceptableStateRouter interceptableStateRouter = (InterceptableStateRouter)stateRouter;
            List<StateRouterInterceptor> interceptorList = EnhancedServiceLoader.loadAll(StateRouterInterceptor.class);
            for (StateRouterInterceptor interceptor : interceptorList) {
                if (!interceptor.match(interceptableStateRouter.getClass())) continue;
                interceptableStateRouter.addInterceptor(interceptor);
            }
        }
    }

    @Override
    public StateLogRepository getStateLogRepository() {
        return this.stateLogRepository;
    }

    @Override
    public StateLogStore getStateLogStore() {
        return this.stateLogStore;
    }

    @Override
    public StateLangStore getStateLangStore() {
        return this.stateLangStore;
    }

    @Override
    public ExpressionFactoryManager getExpressionFactoryManager() {
        return this.expressionFactoryManager;
    }

    @Override
    public ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    @Override
    public StateMachineRepository getStateMachineRepository() {
        return this.stateMachineRepository;
    }

    @Override
    public StatusDecisionStrategy getStatusDecisionStrategy() {
        return this.statusDecisionStrategy;
    }

    @Override
    public SeqGenerator getSeqGenerator() {
        return this.seqGenerator;
    }

    @Override
    public ProcessCtrlEventPublisher getProcessCtrlEventPublisher() {
        return this.syncProcessCtrlEventPublisher;
    }

    @Override
    public ProcessCtrlEventPublisher getAsyncProcessCtrlEventPublisher() {
        return this.asyncProcessCtrlEventPublisher;
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    @Override
    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    @Override
    public ServiceInvokerManager getServiceInvokerManager() {
        return this.serviceInvokerManager;
    }

    @Override
    public int getTransOperationTimeout() {
        return this.transOperationTimeout;
    }

    @Override
    public int getServiceInvokeTimeout() {
        return this.serviceInvokeTimeout;
    }

    @Override
    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public void setExpressionFactoryManager(ExpressionFactoryManager expressionFactoryManager) {
        this.expressionFactoryManager = expressionFactoryManager;
    }

    public void setExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    public void setStateLogRepository(StateLogRepository stateLogRepository) {
        this.stateLogRepository = stateLogRepository;
    }

    public void setStateLogStore(StateLogStore stateLogStore) {
        this.stateLogStore = stateLogStore;
    }

    public void setStateMachineRepository(StateMachineRepository stateMachineRepository) {
        this.stateMachineRepository = stateMachineRepository;
    }

    public void setStateLangStore(StateLangStore stateLangStore) {
        this.stateLangStore = stateLangStore;
    }

    public void setStatusDecisionStrategy(StatusDecisionStrategy statusDecisionStrategy) {
        this.statusDecisionStrategy = statusDecisionStrategy;
    }

    public void setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
    }

    public void setSyncProcessCtrlEventPublisher(ProcessCtrlEventPublisher syncProcessCtrlEventPublisher) {
        this.syncProcessCtrlEventPublisher = syncProcessCtrlEventPublisher;
    }

    public void setAsyncProcessCtrlEventPublisher(ProcessCtrlEventPublisher asyncProcessCtrlEventPublisher) {
        this.asyncProcessCtrlEventPublisher = asyncProcessCtrlEventPublisher;
    }

    public void setTransOperationTimeout(int transOperationTimeout) {
        this.transOperationTimeout = transOperationTimeout;
    }

    public void setServiceInvokeTimeout(int serviceInvokeTimeout) {
        this.serviceInvokeTimeout = serviceInvokeTimeout;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setServiceInvokerManager(ServiceInvokerManager serviceInvokerManager) {
        this.serviceInvokerManager = serviceInvokerManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    public void setSagaJsonParser(String sagaJsonParser) {
        this.sagaJsonParser = sagaJsonParser;
    }

    public void setAutoRegisterResources(boolean autoRegisterResources) {
        this.autoRegisterResources = autoRegisterResources;
    }

    public void setStateMachineDefInputStreamArray(InputStream[] stateMachineDefInputStreamArray) {
        this.stateMachineDefInputStreamArray = stateMachineDefInputStreamArray;
    }

    public String getSagaJsonParser() {
        return this.sagaJsonParser;
    }

    public boolean isAutoRegisterResources() {
        return this.autoRegisterResources;
    }

    public InputStream[] getStateMachineDefInputStreamArray() {
        return this.stateMachineDefInputStreamArray;
    }

    public boolean isSagaRetryPersistModeUpdate() {
        return this.sagaRetryPersistModeUpdate;
    }

    public void setSagaRetryPersistModeUpdate(boolean sagaRetryPersistModeUpdate) {
        this.sagaRetryPersistModeUpdate = sagaRetryPersistModeUpdate;
    }

    public boolean isSagaCompensatePersistModeUpdate() {
        return this.sagaCompensatePersistModeUpdate;
    }

    public void setSagaCompensatePersistModeUpdate(boolean sagaCompensatePersistModeUpdate) {
        this.sagaCompensatePersistModeUpdate = sagaCompensatePersistModeUpdate;
    }

    public boolean isRmReportSuccessEnable() {
        return this.rmReportSuccessEnable;
    }

    public void setRmReportSuccessEnable(boolean rmReportSuccessEnable) {
        this.rmReportSuccessEnable = rmReportSuccessEnable;
    }

    public boolean isSagaBranchRegisterEnable() {
        return this.sagaBranchRegisterEnable;
    }

    public void setSagaBranchRegisterEnable(boolean sagaBranchRegisterEnable) {
        this.sagaBranchRegisterEnable = sagaBranchRegisterEnable;
    }
}

