/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.integration.tx.api.interceptor.ActionContextUtil;
import org.apache.seata.integration.tx.api.util.JsonUtil;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.rm.tcc.api.BusinessActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusinessActionContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessActionContextUtil.class);
    private static final ThreadLocal<BusinessActionContext> CONTEXT_HOLDER = new ThreadLocal();

    private BusinessActionContextUtil() {
    }

    public static boolean addContext(String key, Object value) {
        if (value == null) {
            return false;
        }
        Map<String, Object> newContext = Collections.singletonMap(key, value);
        return BusinessActionContextUtil.addContext(newContext);
    }

    public static boolean addContext(Map<String, Object> context) {
        if (CollectionUtils.isEmpty(context)) {
            return false;
        }
        BusinessActionContext actionContext = BusinessActionContextUtil.getContext();
        if (!ActionContextUtil.putActionContext(actionContext.getActionContext(), context)) {
            return false;
        }
        actionContext.setUpdated(true);
        if (Boolean.TRUE.equals(actionContext.getDelayReport())) {
            return false;
        }
        return BusinessActionContextUtil.reportContext(actionContext);
    }

    public static boolean reportContext(BusinessActionContext actionContext) {
        if (!Boolean.TRUE.equals(actionContext.getUpdated())) {
            return false;
        }
        try {
            DefaultResourceManager.get().branchReport(actionContext.getBranchType(), actionContext.getXid(), actionContext.getBranchId(), BranchStatus.Registered, JsonUtil.toJSONString(Collections.singletonMap("actionContext", actionContext.getActionContext())));
            actionContext.setUpdated(null);
            return true;
        }
        catch (TransactionException e) {
            String msg = String.format("TCC branch update error, xid: %s", actionContext.getXid());
            LOGGER.error("{}, error: {}", (Object)msg, (Object)e.getMessage());
            throw new FrameworkException(e, msg);
        }
    }

    public static BusinessActionContext getContext() {
        return CONTEXT_HOLDER.get();
    }

    public static void setContext(BusinessActionContext context) {
        CONTEXT_HOLDER.set(context);
    }

    public static void clear() {
        CONTEXT_HOLDER.remove();
    }

    public static BusinessActionContext getBusinessActionContext(String xid, long branchId, String resourceId, String applicationData) {
        Map<String, Object> actionContextMap = null;
        if (StringUtils.isNotBlank(applicationData)) {
            Map tccContext = JsonUtil.parseObject(applicationData, Map.class);
            actionContextMap = (Map)tccContext.get("actionContext");
        }
        if (actionContextMap == null) {
            actionContextMap = new HashMap<String, Object>(2);
        }
        BusinessActionContext businessActionContext = new BusinessActionContext(xid, String.valueOf(branchId), actionContextMap);
        businessActionContext.setActionName(resourceId);
        return businessActionContext;
    }
}

