/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.sqlserver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.KeyType;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.rm.datasource.undo.sqlserver.BaseSqlServerUndoExecutor;
import org.apache.seata.sqlparser.struct.SqlServerTableMeta;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class SqlServerUndoDeleteExecutor
extends BaseSqlServerUndoExecutor {
    private boolean tableIdentifyExistence = false;

    public SqlServerUndoDeleteExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        ArrayList<Field> fields = new ArrayList<Field>(row.nonPrimaryKeys());
        fields.addAll(this.getOrderedPkList(beforeImage, row, "sqlserver"));
        String insertColumns = fields.stream().map(field -> ColumnUtils.addEscape(field.getName(), "sqlserver")).collect(Collectors.joining(", "));
        String insertValues = fields.stream().map(field -> "?").collect(Collectors.joining(", "));
        if (this.tableIdentifyExistence) {
            return "begin SET IDENTITY_INSERT " + this.sqlUndoLog.getTableName() + " ON;INSERT INTO " + this.sqlUndoLog.getTableName() + "(" + insertColumns + ") VALUES (" + insertValues + ");SET IDENTITY_INSERT " + this.sqlUndoLog.getTableName() + " OFF; end";
        }
        return "INSERT INTO " + this.sqlUndoLog.getTableName() + "(" + insertColumns + ") VALUES (" + insertValues + ");";
    }

    private void judgeTableIdentifyExistence(ConnectionProxy connectionProxy) {
        TableMeta tableMeta = TableMetaCacheFactory.getTableMetaCache(connectionProxy.getDbType()).getTableMeta(connectionProxy.getTargetConnection(), this.sqlUndoLog.getTableName(), connectionProxy.getDataSourceProxy().getResourceId());
        this.tableIdentifyExistence = ((SqlServerTableMeta)tableMeta).isTableIdentifyExistence();
    }

    @Override
    public void executeOn(ConnectionProxy connectionProxy) throws SQLException {
        Connection conn = connectionProxy.getTargetConnection();
        if (IS_UNDO_DATA_VALIDATION_ENABLE && !this.dataValidationAndGoOn(connectionProxy)) {
            return;
        }
        this.judgeTableIdentifyExistence(connectionProxy);
        PreparedStatement undoPST = null;
        try {
            String undoSQL = this.buildUndoSQL();
            undoPST = conn.prepareStatement(undoSQL);
            TableRecords undoRows = this.getUndoRows();
            for (Row undoRow : undoRows.getRows()) {
                ArrayList<Field> undoValues = new ArrayList<Field>();
                List<Field> pkValueList = this.getOrderedPkList(undoRows, undoRow, connectionProxy.getDbType());
                for (Field field : undoRow.getFields()) {
                    if (field.getKeyType() == KeyType.PRIMARY_KEY) continue;
                    undoValues.add(field);
                }
                this.undoPrepare(undoPST, undoValues, pkValueList);
                undoPST.executeUpdate();
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException(ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(undoPST);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)undoPST);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

