/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.parser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.apache.seata.common.Constants;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.undo.BranchUndoLog;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.apache.seata.rm.datasource.undo.parser.spi.JacksonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="jackson")
public class JacksonUndoLogParser
implements UndoLogParser,
Initialize {
    public static final String NAME = "jackson";
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUndoLogParser.class);
    private static final String DM_JDBC_DRIVER_DMDB_TIMESTAMP = "dm.jdbc.driver.DmdbTimestamp";
    private static final String VALUE_OF = "valueOf";
    private static ZoneId zoneId = ZoneId.systemDefault();
    private final ObjectMapper mapper = new ObjectMapper();
    private final SimpleModule module = new SimpleModule();
    private final JsonSerializer timestampSerializer = new TimestampSerializer();
    private final JsonDeserializer timestampDeserializer = new TimestampDeserializer();
    private final JsonSerializer blobSerializer = new BlobSerializer();
    private final JsonDeserializer blobDeserializer = new BlobDeserializer();
    private final JsonSerializer clobSerializer = new ClobSerializer();
    private final JsonDeserializer clobDeserializer = new ClobDeserializer();
    private final JsonSerializer localDateTimeSerializer = new LocalDateTimeSerializer();
    private final JsonDeserializer localDateTimeDeserializer = new LocalDateTimeDeserializer();
    private final JsonSerializer dmdbTimestampSerializer = new DmdbTimestampSerializer();
    private final JsonDeserializer dmdbTimestampDeserializer = new DmdbTimestampDeserializer();

    @Override
    public void init() {
        try {
            List<JacksonSerializer> jacksonSerializers = EnhancedServiceLoader.loadAll(JacksonSerializer.class);
            if (CollectionUtils.isNotEmpty(jacksonSerializers)) {
                for (JacksonSerializer jacksonSerializer : jacksonSerializers) {
                    Class type = jacksonSerializer.type();
                    JsonSerializer ser = jacksonSerializer.ser();
                    JsonDeserializer deser = jacksonSerializer.deser();
                    if (type == null) continue;
                    if (ser != null) {
                        this.module.addSerializer(type, ser);
                    }
                    if (deser != null) {
                        this.module.addDeserializer(type, deser);
                    }
                    LOGGER.info("jackson undo log parser load [{}].", (Object)jacksonSerializer.getClass().getName());
                }
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            LOGGER.warn("JacksonSerializer not found children class.", (Throwable)((Object)e));
        }
        this.module.addSerializer(Timestamp.class, this.timestampSerializer);
        this.module.addDeserializer(Timestamp.class, this.timestampDeserializer);
        this.module.addSerializer(SerialBlob.class, this.blobSerializer);
        this.module.addDeserializer(SerialBlob.class, this.blobDeserializer);
        this.module.addSerializer(SerialClob.class, this.clobSerializer);
        this.module.addDeserializer(SerialClob.class, this.clobDeserializer);
        this.module.addSerializer(LocalDateTime.class, this.localDateTimeSerializer);
        this.module.addDeserializer(LocalDateTime.class, this.localDateTimeDeserializer);
        this.registerDmdbTimestampModuleIfPresent();
        this.mapper.registerModule((Module)this.module);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        this.mapper.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
    }

    private void registerDmdbTimestampModuleIfPresent() {
        try {
            Class<?> dmdbTimestampClass = Class.forName(DM_JDBC_DRIVER_DMDB_TIMESTAMP);
            this.module.addSerializer(dmdbTimestampClass, this.dmdbTimestampSerializer);
            this.module.addDeserializer(dmdbTimestampClass, this.dmdbTimestampDeserializer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return "{}".getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        try {
            return this.mapper.writeValueAsBytes((Object)branchUndoLog);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("json encode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        try {
            BranchUndoLog branchUndoLog = Arrays.equals(bytes, this.getDefaultContent()) ? new BranchUndoLog() : (BranchUndoLog)this.mapper.readValue(bytes, BranchUndoLog.class);
            return branchUndoLog;
        }
        catch (IOException e) {
            LOGGER.error("json decode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void setZoneOffset(ZoneId zoneId) {
        Objects.requireNonNull(zoneId, "zoneId must be not null");
        JacksonUndoLogParser.zoneId = zoneId;
    }

    public class DmdbTimestampDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) {
            try {
                Instant instant = this.parseInstant(p);
                return this.createDmdbTimestamp(instant);
            }
            catch (Exception e) {
                LOGGER.error("deserialize dm.jdbc.driver.DmdbTimestamp error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }

        private Instant parseInstant(JsonParser p) throws IOException {
            try {
                if (p.isExpectedStartArrayToken()) {
                    ArrayNode arrayNode = (ArrayNode)p.getCodec().readTree(p);
                    long timestamp = arrayNode.get(0).asLong();
                    Instant instant = Instant.ofEpochMilli(timestamp);
                    if (arrayNode.size() > 1) {
                        int nano = arrayNode.get(1).asInt();
                        instant = instant.plusNanos(nano % 1000000);
                    }
                    return instant;
                }
                long timestamp = p.getLongValue();
                return Instant.ofEpochMilli(timestamp);
            }
            catch (IOException e) {
                throw new IOException("Error parsing Instant from JSON", e);
            }
        }

        private Object createDmdbTimestamp(Instant instant) throws Exception {
            Class<?> dmdbTimestampClass = Class.forName(JacksonUndoLogParser.DM_JDBC_DRIVER_DMDB_TIMESTAMP);
            Method valueOfMethod = dmdbTimestampClass.getMethod(JacksonUndoLogParser.VALUE_OF, ZonedDateTime.class);
            return valueOfMethod.invoke(null, instant.atZone(zoneId));
        }
    }

    private static class DmdbTimestampSerializer
    extends JsonSerializer<Object> {
        private static final String TO_INSTANT = "toInstant";
        private static final String GET_NANOS = "getNanos";

        private DmdbTimestampSerializer() {
        }

        public void serializeWithType(Object dmdbTimestamp, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            JsonToken valueShape = JsonToken.VALUE_NUMBER_INT;
            int nanos = this.getNanos(dmdbTimestamp);
            if (nanos % 1000000 > 0) {
                valueShape = JsonToken.START_ARRAY;
            }
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(dmdbTimestamp, valueShape));
            this.serialize(dmdbTimestamp, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(Object dmdbTimestamp, JsonGenerator gen, SerializerProvider serializers) {
            try {
                Instant instant = this.getInstant(dmdbTimestamp);
                gen.writeNumber(instant.toEpochMilli());
                int nanos = instant.getNano();
                if (nanos % 1000000 > 0) {
                    gen.writeNumber(nanos);
                }
            }
            catch (Exception e) {
                LOGGER.error("serialize dm.jdbc.driver.DmdbTimestamp error : {}", (Object)e.getMessage(), (Object)e);
            }
        }

        private int getNanos(Object dmdbTimestamp) throws IOException {
            try {
                Method getNanosMethod = dmdbTimestamp.getClass().getMethod(GET_NANOS, new Class[0]);
                return (Integer)getNanosMethod.invoke(dmdbTimestamp, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Error getting nanos value from DmdbTimestamp", e);
            }
        }

        private Instant getInstant(Object dmdbTimestamp) throws IOException {
            try {
                Method toInstantMethod = dmdbTimestamp.getClass().getMethod(TO_INSTANT, new Class[0]);
                return (Instant)toInstantMethod.invoke(dmdbTimestamp, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException("Error getting instant from DmdbTimestamp", e);
            }
        }
    }

    private static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeDeserializer() {
        }

        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                Instant instant;
                if (p.isExpectedStartArrayToken()) {
                    ArrayNode arrayNode = (ArrayNode)p.getCodec().readTree(p);
                    long timestamp = arrayNode.get(0).asLong();
                    instant = Instant.ofEpochMilli(timestamp);
                    if (arrayNode.size() > 1) {
                        int nano = arrayNode.get(1).asInt();
                        instant = instant.plusNanos(nano % 1000000);
                    }
                } else {
                    long timestamp = p.getLongValue();
                    instant = Instant.ofEpochMilli(timestamp);
                }
                return LocalDateTime.ofInstant(instant, zoneId);
            }
            catch (Exception e) {
                LOGGER.error("deserialize java.time.LocalDateTime error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        public void serializeWithType(LocalDateTime localDateTime, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            JsonToken valueShape = JsonToken.VALUE_NUMBER_INT;
            if (localDateTime.getNano() % 1000000 > 0) {
                valueShape = JsonToken.START_ARRAY;
            }
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)localDateTime, valueShape));
            this.serialize(localDateTime, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(LocalDateTime localDateTime, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                Instant instant = localDateTime.atZone(zoneId).toInstant();
                gen.writeNumber(instant.toEpochMilli());
                if (instant.getNano() % 1000000 > 0) {
                    gen.writeNumber(instant.getNano());
                }
            }
            catch (IOException e) {
                LOGGER.error("serialize java.time.LocalDateTime error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class ClobDeserializer
    extends JsonDeserializer<SerialClob> {
        private ClobDeserializer() {
        }

        public SerialClob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialClob(p.getValueAsString().toCharArray());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Clob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class ClobSerializer
    extends JsonSerializer<SerialClob> {
        private ClobSerializer() {
        }

        public void serializeWithType(SerialClob clob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)clob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(clob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialClob clob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try (Reader r = clob.getCharacterStream();){
                gen.writeString(r, (int)clob.length());
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class BlobDeserializer
    extends JsonDeserializer<SerialBlob> {
        private BlobDeserializer() {
        }

        public SerialBlob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialBlob(p.getBinaryValue());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class BlobSerializer
    extends JsonSerializer<SerialBlob> {
        private BlobSerializer() {
        }

        public void serializeWithType(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)blob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(blob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeBinary(blob.getBytes(1L, (int)blob.length()));
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        private TimestampDeserializer() {
        }

        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) {
            try {
                if (p.isExpectedStartArrayToken()) {
                    ArrayNode arrayNode = (ArrayNode)p.getCodec().readTree(p);
                    Timestamp timestamp = new Timestamp(arrayNode.get(0).asLong());
                    timestamp.setNanos(arrayNode.get(1).asInt());
                    return timestamp;
                }
                long timestamp = p.getLongValue();
                return new Timestamp(timestamp);
            }
            catch (IOException e) {
                LOGGER.error("deserialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        private TimestampSerializer() {
        }

        public void serializeWithType(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            JsonToken valueShape = JsonToken.VALUE_NUMBER_INT;
            if (timestamp.getNanos() % 1000000 > 0) {
                valueShape = JsonToken.START_ARRAY;
            }
            WritableTypeId typeId = typeSerializer.writeTypePrefix(gen, typeSerializer.typeId((Object)timestamp, valueShape));
            this.serialize(timestamp, gen, serializers);
            gen.writeTypeSuffix(typeId);
        }

        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) {
            try {
                gen.writeNumber(timestamp.getTime());
                if (timestamp.getNanos() % 1000000 > 0) {
                    gen.writeNumber(timestamp.getNanos());
                }
            }
            catch (IOException e) {
                LOGGER.error("serialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

