/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.mysql;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.SqlGenerateUtils;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.AbstractUndoExecutor;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.rm.datasource.undo.mysql.MySQLJsonHelper;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class MySQLUndoUpdateExecutor
extends AbstractUndoExecutor {
    private static final String UPDATE_SQL_TEMPLATE = "UPDATE %s SET %s WHERE %s ";

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        List<Field> nonPkFields = row.nonPrimaryKeys();
        String updateColumns = nonPkFields.stream().map(field -> {
            String addEscape = ColumnUtils.addEscape(field.getName(), "mysql");
            return addEscape + " = " + MySQLJsonHelper.convertIfJson(field, beforeImage.getTableMeta());
        }).collect(Collectors.joining(", "));
        List<String> pkNameList = this.getOrderedPkList(beforeImage, row, "mysql").stream().map(e -> e.getName()).collect(Collectors.toList());
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, "mysql");
        return String.format(UPDATE_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), updateColumns, whereSql);
    }

    public MySQLUndoUpdateExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

