/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo;

import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.rm.datasource.undo.AbstractUndoExecutor;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.rm.datasource.undo.UndoExecutorHolder;
import org.apache.seata.rm.datasource.undo.UndoExecutorHolderFactory;

public class UndoExecutorFactory {
    public static AbstractUndoExecutor getUndoExecutor(String dbType, SQLUndoLog sqlUndoLog) {
        AbstractUndoExecutor result = null;
        UndoExecutorHolder holder = UndoExecutorHolderFactory.getUndoExecutorHolder(dbType.toLowerCase());
        switch (sqlUndoLog.getSqlType()) {
            case INSERT: {
                result = holder.getInsertExecutor(sqlUndoLog);
                break;
            }
            case UPDATE: 
            case UPDATE_JOIN: {
                result = holder.getUpdateExecutor(sqlUndoLog);
                break;
            }
            case DELETE: {
                result = holder.getDeleteExecutor(sqlUndoLog);
                break;
            }
            default: {
                throw new NotSupportYetException(String.format("sql type: %s not support", new Object[]{sqlUndoLog.getSqlType()}));
            }
        }
        return result;
    }
}

