/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.sql.handler.sqlserver;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.sqlparser.EscapeHandler;
import org.apache.seata.sqlparser.EscapeSymbol;
import org.apache.seata.sqlparser.struct.TableMeta;

@LoadLevel(name="sqlserver")
public class SqlServerEscapeHandler
implements EscapeHandler {
    private Set<String> keywordSet = Arrays.stream(SqlServerKeyword.values()).map(Enum::name).collect(Collectors.toSet());
    private static final EscapeSymbol ESCAPE_SYMBOL = new EscapeSymbol('[', ']');

    @Override
    public boolean checkIfKeyWords(String fieldOrTableName) {
        if (this.keywordSet.contains(fieldOrTableName)) {
            return true;
        }
        if (fieldOrTableName != null) {
            fieldOrTableName = fieldOrTableName.toUpperCase();
        }
        return this.keywordSet.contains(fieldOrTableName);
    }

    @Override
    public boolean checkIfNeedEscape(String columnName, TableMeta tableMeta) {
        return this.checkIfKeyWords(columnName);
    }

    @Override
    public EscapeSymbol getEscapeSymbol() {
        return ESCAPE_SYMBOL;
    }

    private static enum SqlServerKeyword {
        ADD("ADD"),
        ALL("ALL"),
        ALTER("ALTER"),
        AND("AND"),
        ANY("ANY"),
        AS("AS"),
        ASC("ASC"),
        AUTHORIZATION("AUTHORIZATION"),
        BACKUP("BACKUP"),
        BEGIN("BEGIN"),
        BETWEEN("BETWEEN"),
        BREAK("BREAK"),
        BROWSE("BROWSE"),
        BULK("BULK"),
        BY("BY"),
        CASCADE("CASCADE"),
        CASE("CASE"),
        CHECK("CHECK"),
        CHECKPOINT("CHECKPOINT"),
        CLOSE("CLOSE"),
        CLUSTERED("CLUSTERED"),
        COALESCE("COALESCE"),
        COLLATE("COLLATE"),
        COLUMN("COLUMN"),
        COMMIT("COMMIT"),
        COMPUTE("COMPUTE"),
        CONSTRAINT("CONSTRAINT"),
        CONTAINS("CONTAINS"),
        CONTAINSTABLE("CONTAINSTABLE"),
        CONTINUE("CONTINUE"),
        CONVERT("CONVERT"),
        CREATE("CREATE"),
        CROSS("CROSS"),
        CURRENT("CURRENT"),
        CURRENT_DATE("CURRENT_DATE"),
        CURRENT_TIME("CURRENT_TIME"),
        CURRENT_TIMESTAMP("CURRENT_TIMESTAMP"),
        CURRENT_USER("CURRENT_USER"),
        CURSOR("CURSOR"),
        DATABASE("DATABASE"),
        DBCC("DBCC"),
        DEALLOCATE("DEALLOCATE"),
        DECLARE("DECLARE"),
        DEFAULT("DEFAULT"),
        DELETE("DELETE"),
        DENY("DENY"),
        DESC("DESC"),
        DISK("DISK"),
        DISTINCT("DISTINCT"),
        DISTRIBUTED("DISTRIBUTED"),
        DOUBLE("DOUBLE"),
        DROP("DROP"),
        DUMP("DUMP"),
        ELSE("ELSE"),
        End("End"),
        ERRLVL("ERRLVL"),
        ESCAPE("ESCAPE"),
        EXCEPT("EXCEPT"),
        EXEC("EXEC"),
        EXECUTE("EXECUTE"),
        EXISTS("EXISTS"),
        EXIT("EXIT"),
        EXTERNAL("EXTERNAL"),
        FETCH("FETCH"),
        FILE("FILE"),
        FILLFACTOR("FILLFACTOR"),
        FOR("FOR"),
        FOREIGN("FOREIGN"),
        FREETEXT("FREETEXT"),
        FREETEXTTABLE("FREETEXTTABLE"),
        FROM("FROM"),
        FULL("FULL"),
        FUNCTION("FUNCTION"),
        GOTO("GOTO"),
        GRANT("GRANT"),
        GROUP("GROUP"),
        HAVING("HAVING"),
        HOLDLOCK("HOLDLOCK"),
        IDENTITY("IDENTITY"),
        IDENTITY_INSERT("IDENTITY_INSERT"),
        IDENTITYCOL("IDENTITYCOL"),
        IF("IF"),
        IN("IN"),
        INDEX("INDEX"),
        INNER("INNER"),
        INSERT("INSERT"),
        INTERSECT("INTERSECT"),
        INTO("INTO"),
        IS("IS"),
        JOIN("JOIN"),
        KEY("KEY"),
        KILL("KILL"),
        LEFT("LEFT"),
        LIKE("LIKE"),
        LINENO("LINENO"),
        LOAD("LOAD"),
        MERGE("MERGE"),
        NATIONAL("NATIONAL"),
        NOCHECK("NOCHECK"),
        NONCLUSTERED("NONCLUSTERED"),
        NOT("NOT"),
        NULL("NULL"),
        NULLIF("NULLIF"),
        OF("OF"),
        OFF("OFF"),
        OFFSETS("OFFSETS"),
        ON("ON"),
        OPEN("OPEN"),
        OPENDATASOURCE("OPENDATASOURCE"),
        OPENQUERY("OPENQUERY"),
        OPENROWSET("OPENROWSET"),
        OPENXML("OPENXML"),
        OPTION("OPTION"),
        OR("OR"),
        ORDER("ORDER"),
        OUTER("OUTER"),
        OVER("OVER"),
        PERCENT("PERCENT"),
        PIVOT("PIVOT"),
        PLAN("PLAN"),
        PRECISION("PRECISION"),
        PRIMARY("PRIMARY"),
        PRINT("PRINT"),
        PROC("PROC"),
        PROCEDURE("PROCEDURE"),
        PUBLIC("PUBLIC"),
        RAISERROR("RAISERROR"),
        READ("READ"),
        READTEXT("READTEXT"),
        RECONFIGURE("RECONFIGURE"),
        REFERENCES("REFERENCES"),
        REPLICATION("REPLICATION"),
        RESTORE("RESTORE"),
        RESTRICT("RESTRICT"),
        RETURN("RETURN"),
        REVERT("REVERT"),
        REVOKE("REVOKE"),
        RIGHT("RIGHT"),
        ROLLBACK("ROLLBACK"),
        ROWCOUNT("ROWCOUNT"),
        ROWGUIDCOL("ROWGUIDCOL"),
        RULE("RULE"),
        SAVE("SAVE"),
        SCHEMA("SCHEMA"),
        SECURITYAUDIT("SECURITYAUDIT"),
        SELECT("SELECT"),
        SEMANTICKEYPHRASETABLE("SEMANTICKEYPHRASETABLE"),
        SEMANTICSIMILARITYDETAILSTABLE("SEMANTICSIMILARITYDETAILSTABLE"),
        SEMANTICSIMILARITYTABLE("SEMANTICSIMILARITYTABLE"),
        SESSION_USER("SESSION_USER"),
        SET("SET"),
        SETUSER("SETUSER"),
        SHUTDOWN("SHUTDOWN"),
        SOME("SOME"),
        STATISTICS("STATISTICS"),
        SYSTEM_USER("SYSTEM_USER"),
        TABLE("TABLE"),
        TABLESAMPLE("TABLESAMPLE"),
        TEXTSIZE("TEXTSIZE"),
        THEN("THEN"),
        TO("TO"),
        TOP("TOP"),
        TRAN("TRAN"),
        TRANSACTION("TRANSACTION"),
        TRIGGER("TRIGGER"),
        TRUNCATE("TRUNCATE"),
        TRY_CONVERT("TRY_CONVERT"),
        TSEQUAL("TSEQUAL"),
        UNION("UNION"),
        UNIQUE("UNIQUE"),
        UNPIVOT("UNPIVOT"),
        UPDATE("UPDATE"),
        UPDATETEXT("UPDATETEXT"),
        USE("USE"),
        USER("USER"),
        VALUES("VALUES"),
        VARYING("VARYING"),
        VIEW("VIEW"),
        WAITFOR("WAITFOR"),
        WHEN("WHEN"),
        WHERE("WHERE"),
        WHILE("WHILE"),
        WITH("WITH"),
        WITHINGROUP("WITHIN GROUP"),
        WRITETEXT("WRITETEXT");

        public final String name;

        private SqlServerKeyword(String name) {
            this.name = name;
        }
    }
}

