/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec.mysql;

import com.google.common.base.Joiner;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.LowerCaseLinkHashMap;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.PreparedStatementProxy;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.exec.mysql.MySQLInsertExecutor;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.sqlparser.SQLInsertRecognizer;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLType;
import org.apache.seata.sqlparser.struct.ColumnMeta;
import org.apache.seata.sqlparser.struct.Defaultable;
import org.apache.seata.sqlparser.struct.IndexMeta;
import org.apache.seata.sqlparser.struct.Null;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.apache.seata.sqlparser.util.ColumnUtils;

@LoadLevel(name="mysql", scope=Scope.PROTOTYPE)
public class MySQLInsertOnDuplicateUpdateExecutor
extends MySQLInsertExecutor
implements Defaultable {
    private static final String COLUMN_SEPARATOR = "|";
    private boolean isUpdateFlag = false;
    private String selectSQL;
    private ArrayList<List<Object>> paramAppenderList;
    private Set<String> primaryKeysInBeforeImageSql = new HashSet<String>(4);

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public ArrayList<List<Object>> getParamAppenderList() {
        return this.paramAppenderList;
    }

    public MySQLInsertOnDuplicateUpdateExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected Object executeAutoCommitFalse(Object[] args) throws Exception {
        if (!"mysql".equalsIgnoreCase(this.getDbType()) && this.getTableMeta().getPrimaryKeyOnlyName().size() > 1) {
            throw new NotSupportYetException("multi pk only support mysql!");
        }
        TableRecords beforeImage = this.beforeImage();
        if (CollectionUtils.isNotEmpty(beforeImage.getRows())) {
            this.isUpdateFlag = true;
        } else {
            beforeImage = TableRecords.empty(this.getTableMeta());
        }
        Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
        int updateCount = this.statementProxy.getUpdateCount();
        if (updateCount > 0) {
            TableRecords afterImage = this.afterImage(beforeImage);
            this.prepareUndoLogAll(beforeImage, afterImage);
        }
        return result;
    }

    protected void prepareUndoLogAll(TableRecords beforeImage, TableRecords afterImage) {
        if (beforeImage.getRows().isEmpty() && afterImage.getRows().isEmpty()) {
            return;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        String lockKeys = this.buildLockKey(afterImage);
        connectionProxy.appendLockKey(lockKeys);
        this.buildUndoItemAll(connectionProxy, beforeImage, afterImage);
    }

    protected void buildUndoItemAll(ConnectionProxy connectionProxy, TableRecords beforeImage, TableRecords afterImage) {
        TableRecords partAfterImage;
        if (!this.isUpdateFlag) {
            SQLUndoLog sqlUndoLog = this.buildUndoItem(SQLType.INSERT, TableRecords.empty(this.getTableMeta()), afterImage);
            connectionProxy.appendUndoLog(sqlUndoLog);
            return;
        }
        List<Row> beforeImageRows = beforeImage.getRows();
        ArrayList<String> beforePrimaryValues = new ArrayList<String>();
        for (Row r : beforeImageRows) {
            String primaryValue = "";
            for (Field f : r.primaryKeys()) {
                primaryValue = primaryValue + f.getValue() + COLUMN_SEPARATOR;
            }
            beforePrimaryValues.add(primaryValue);
        }
        ArrayList<Row> insertRows = new ArrayList<Row>();
        ArrayList<Row> updateRows = new ArrayList<Row>();
        List<Row> afterImageRows = afterImage.getRows();
        for (Row r : afterImageRows) {
            String primaryValue = "";
            for (Field f : r.primaryKeys()) {
                primaryValue = primaryValue + f.getValue() + COLUMN_SEPARATOR;
            }
            if (beforePrimaryValues.contains(primaryValue)) {
                updateRows.add(r);
                continue;
            }
            insertRows.add(r);
        }
        if (CollectionUtils.isNotEmpty(updateRows)) {
            partAfterImage = new TableRecords(afterImage.getTableMeta());
            partAfterImage.setTableName(afterImage.getTableName());
            partAfterImage.setRows(updateRows);
            if (beforeImage.getRows().size() != partAfterImage.getRows().size()) {
                throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
            }
            connectionProxy.appendUndoLog(this.buildUndoItem(SQLType.UPDATE, beforeImage, partAfterImage));
        }
        if (CollectionUtils.isNotEmpty(insertRows)) {
            partAfterImage = new TableRecords(afterImage.getTableMeta());
            partAfterImage.setTableName(afterImage.getTableName());
            partAfterImage.setRows(insertRows);
            connectionProxy.appendUndoLog(this.buildUndoItem(SQLType.INSERT, TableRecords.empty(this.getTableMeta()), partAfterImage));
        }
    }

    protected SQLUndoLog buildUndoItem(SQLType sqlType, TableRecords beforeImage, TableRecords afterImage) {
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableMeta tableMeta = this.getTableMeta();
        List<Row> rows = beforeImage.getRows();
        HashMap<String, ArrayList> primaryValueMap = new HashMap<String, ArrayList>();
        rows.forEach(m -> {
            List<Field> fields = m.primaryKeys();
            fields.forEach(f -> {
                ArrayList values = primaryValueMap.computeIfAbsent(f.getName(), v -> new ArrayList());
                values.add(f.getValue());
            });
        });
        StringBuilder afterImageSql = new StringBuilder(this.selectSQL);
        ArrayList<Object> primaryValues = new ArrayList<Object>();
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList wherePrimaryList = new ArrayList();
            primaryValueMap.forEach((k, v) -> {
                if (!this.primaryKeysInBeforeImageSql.contains(k)) {
                    wherePrimaryList.add(k + " = ? ");
                    primaryValues.add(v);
                }
            });
            if (wherePrimaryList.size() <= 0) continue;
            afterImageSql.append(" OR (").append(Joiner.on((String)" and ").join(wherePrimaryList)).append(") ");
        }
        return this.buildTableRecords2(tableMeta, afterImageSql.toString(), this.paramAppenderList, primaryValues);
    }

    @Override
    public TableRecords beforeImage() throws SQLException {
        TableMeta tableMeta = this.getTableMeta();
        if (StringUtils.isBlank(this.selectSQL)) {
            this.paramAppenderList = new ArrayList();
            this.selectSQL = this.buildImageSQL(tableMeta);
        }
        return this.buildTableRecords2(tableMeta, this.selectSQL, this.paramAppenderList, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRecords buildTableRecords2(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList, List<Object> primaryKeys) throws SQLException {
        TableRecords tableRecords;
        if (CollectionUtils.isEmpty(paramAppenderList)) {
            throw new NotSupportYetException("the SQL statement has no primary key or unique index value, it will not hit any row data.recommend to convert to a normal insert statement");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int i;
            ps = this.statementProxy.getConnection().prepareStatement(primaryKeys.isEmpty() ? selectSQL + " FOR UPDATE" : selectSQL);
            int paramAppenderCount = 0;
            int ts = CollectionUtils.isEmpty(paramAppenderList) ? 0 : paramAppenderList.size();
            for (i = 0; i < ts; ++i) {
                List<Object> paramAppender = paramAppenderList.get(i);
                for (int j = 0; j < paramAppender.size(); ++j) {
                    Object param = paramAppender.get(j);
                    ps.setObject(paramAppenderCount + 1, param instanceof Null ? null : param);
                    ++paramAppenderCount;
                }
            }
            for (i = 0; i < primaryKeys.size(); ++i) {
                ps.setObject(paramAppenderCount + i + 1, primaryKeys.get(i));
            }
            rs = ps.executeQuery();
            tableRecords = TableRecords.buildRecords(tableMeta, rs);
        }
        catch (Throwable throwable) {
            IOUtil.close(rs, ps);
            throw throwable;
        }
        IOUtil.close(rs, ps);
        return tableRecords;
    }

    public String buildImageSQL(TableMeta tableMeta) {
        if (CollectionUtils.isEmpty(this.paramAppenderList)) {
            this.paramAppenderList = new ArrayList();
        }
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        int insertNum = recognizer.getInsertRows(this.getPkIndex().values()).size();
        Map<String, ArrayList<Object>> imageParameterMap = this.buildImageParameters(recognizer);
        String prefix = "SELECT * ";
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        boolean[] isContainWhere = new boolean[]{false};
        for (int i = 0; i < insertNum; ++i) {
            int finalI = i;
            ArrayList paramAppenderTempList = new ArrayList();
            tableMeta.getAllIndexes().forEach((k, v) -> {
                if (!v.isNonUnique() && this.isIndexValueNotNull((IndexMeta)v, imageParameterMap, finalI)) {
                    boolean columnIsNull = true;
                    ArrayList<String> uniqueList = new ArrayList<String>();
                    for (ColumnMeta m : v.getValues()) {
                        String columnName = m.getColumnName();
                        List imageParameters = (List)imageParameterMap.get(columnName);
                        if (imageParameters == null && m.getColumnDef() != null) {
                            uniqueList.add(columnName + " = DEFAULT(" + columnName + ") ");
                            if ("PRIMARY".equalsIgnoreCase((String)k)) {
                                this.primaryKeysInBeforeImageSql.add(columnName);
                            }
                            columnIsNull = false;
                            continue;
                        }
                        if ("PRIMARY".equalsIgnoreCase((String)k)) {
                            this.primaryKeysInBeforeImageSql.add(columnName);
                        }
                        columnIsNull = false;
                        uniqueList.add(columnName + " = ? ");
                        paramAppenderTempList.add(imageParameters.get(finalI));
                    }
                    if (!columnIsNull) {
                        if (isContainWhere[0]) {
                            suffix.append(" OR (").append(Joiner.on((String)" and ").join(uniqueList)).append(") ");
                        } else {
                            suffix.append(" WHERE (").append(Joiner.on((String)" and ").join(uniqueList)).append(") ");
                            isContainWhere[0] = true;
                        }
                    }
                }
            });
            if (!CollectionUtils.isNotEmpty(paramAppenderTempList)) continue;
            this.paramAppenderList.add(paramAppenderTempList);
        }
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix, suffix.toString());
        return selectSQLJoin.toString();
    }

    public Map<String, ArrayList<Object>> buildImageParameters(SQLInsertRecognizer recognizer) {
        List<String> duplicateKeyUpdateColumns = recognizer.getDuplicateKeyUpdate();
        if (CollectionUtils.isNotEmpty(duplicateKeyUpdateColumns)) {
            List duplicateKeyUpdateLowerCaseColumns = duplicateKeyUpdateColumns.parallelStream().map(String::toLowerCase).collect(Collectors.toList());
            this.getTableMeta().getAllIndexes().forEach((k, v) -> {
                if ("PRIMARY".equalsIgnoreCase((String)k)) {
                    for (ColumnMeta m : v.getValues()) {
                        if (!duplicateKeyUpdateLowerCaseColumns.contains(m.getColumnName().toLowerCase())) continue;
                        throw new ShouldNeverHappenException("update pk value is not supported!");
                    }
                }
            });
        }
        LowerCaseLinkHashMap<ArrayList<Object>> imageParameterMap = new LowerCaseLinkHashMap<ArrayList<Object>>();
        Map<Integer, ArrayList<Object>> parameters = ((PreparedStatementProxy)this.statementProxy).getParameters();
        ArrayList<String> sqlRecognizerColumns = recognizer.getInsertColumns();
        ArrayList<String> insertColumns = CollectionUtils.isEmpty(sqlRecognizerColumns) ? new ArrayList<String>(this.getTableMeta().getAllColumns().keySet()) : sqlRecognizerColumns;
        Map<String, Integer> pkIndexMap = this.getPkIndex();
        List<List<Object>> insertRows = recognizer.getInsertRows(pkIndexMap.values());
        int placeHolderIndex = 1;
        for (List<Object> row : insertRows) {
            if (row.size() != insertColumns.size()) {
                throw new IllegalArgumentException("insert row's size is not equal to column size");
            }
            for (int i = 0; i < insertColumns.size(); ++i) {
                String column = ColumnUtils.delEscape((String)insertColumns.get(i), this.getDbType());
                Object value = row.get(i);
                ArrayList columnImages = imageParameterMap.computeIfAbsent(column, k -> new ArrayList());
                if ("?".equals(value)) {
                    ArrayList<Object> objects = parameters.get(placeHolderIndex);
                    columnImages.addAll(objects);
                    ++placeHolderIndex;
                } else {
                    columnImages.add(value);
                }
                imageParameterMap.put(column, (ArrayList<Object>)columnImages);
            }
        }
        return imageParameterMap;
    }

    private boolean isIndexValueNotNull(IndexMeta indexMeta, Map<String, ArrayList<Object>> imageParameterMap, int rowIndex) {
        for (ColumnMeta columnMeta : indexMeta.getValues()) {
            String columnName = columnMeta.getColumnName();
            List imageParameters = imageParameterMap.get(columnName);
            if (imageParameters == null && columnMeta.getColumnDef() == null) {
                return false;
            }
            if (imageParameters == null || imageParameters.get(rowIndex) != null && !(imageParameters.get(rowIndex) instanceof Null)) continue;
            return false;
        }
        return true;
    }
}

