/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm;

import org.apache.seata.core.context.GlobalLockConfigHolder;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.GlobalLockConfig;
import org.apache.seata.rm.GlobalLockExecutor;

public class GlobalLockTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(GlobalLockExecutor executor) throws Throwable {
        boolean alreadyInGlobalLock = RootContext.requireGlobalLock();
        if (!alreadyInGlobalLock) {
            RootContext.bindGlobalLockFlag();
        }
        GlobalLockConfig myConfig = executor.getGlobalLockConfig();
        GlobalLockConfig previousConfig = GlobalLockConfigHolder.setAndReturnPrevious(myConfig);
        try {
            Object object = executor.execute();
            return object;
        }
        finally {
            if (!alreadyInGlobalLock) {
                RootContext.unbindGlobalLockFlag();
            }
            if (previousConfig != null) {
                GlobalLockConfigHolder.setAndReturnPrevious(previousConfig);
            } else {
                GlobalLockConfigHolder.remove();
            }
        }
    }
}

