/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.sofa.rpc;

import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="transactionContextConsumer")
@AutoActive(consumerSide=true)
public class TransactionContextConsumerFilter
extends Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionContextConsumerFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaResponse invoke(FilterInvoker filterInvoker, SofaRequest sofaRequest) throws SofaRpcException {
        String xid = RootContext.getXID();
        String rpcXid = this.getRpcXid();
        BranchType branchType = RootContext.getBranchType();
        String rpcBranchType = this.getBranchType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("context in RootContext[{},{}], context in RpcContext[{},{}]", new Object[]{xid, branchType, rpcXid, rpcBranchType});
        }
        boolean bind = false;
        if (xid != null) {
            sofaRequest.addRequestProp("TX_XID", (Object)xid);
            sofaRequest.addRequestProp("TX_BRANCH_TYPE", (Object)branchType.name());
        } else if (rpcXid != null) {
            RootContext.bind(rpcXid);
            if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType)) {
                RootContext.bindBranchType(BranchType.TCC);
            }
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[{}] to RootContext", (Object)rpcXid);
            }
        }
        try {
            SofaResponse sofaResponse = filterInvoker.invoke(sofaRequest);
            return sofaResponse;
        }
        finally {
            if (bind) {
                BranchType previousBranchType;
                String unbindXid = RootContext.unbind();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind[{}] from RootContext", (Object)unbindXid);
                }
                if (BranchType.TCC == (previousBranchType = RootContext.getBranchType())) {
                    RootContext.unbindBranchType();
                }
                if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("xid in change during RPC from [{}] to [{}]", (Object)rpcXid, (Object)unbindXid);
                    }
                    if (unbindXid != null) {
                        RootContext.bind(unbindXid);
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("bind [{}] back to RootContext", (Object)unbindXid);
                        }
                        if (BranchType.TCC == previousBranchType) {
                            RootContext.bindBranchType(BranchType.TCC);
                            LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                        }
                    }
                }
            }
        }
    }

    private String getRpcXid() {
        String rpcXid = (String)RpcInternalContext.getContext().getAttachment(".TX_XID");
        if (rpcXid == null) {
            rpcXid = (String)RpcInternalContext.getContext().getAttachment(".TX_XID".toLowerCase());
        }
        return rpcXid;
    }

    private String getBranchType() {
        return (String)RpcInternalContext.getContext().getAttachment(".TX_BRANCH_TYPE");
    }
}

