/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.rocketmq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.rocketmq.SeataMQProducer;
import org.apache.seata.integration.rocketmq.TCCRocketMQ;
import org.apache.seata.integration.rocketmq.TCCRocketMQImpl;
import org.apache.seata.integration.tx.api.util.ProxyUtil;

public class SeataMQProducerFactory {
    public static final String ROCKET_TCC_NAME = "tccRocketMQ";
    public static final BranchType ROCKET_BRANCH_TYPE = BranchType.TCC;
    private static SeataMQProducer defaultProducer;

    public static SeataMQProducer createSingle(String nameServer, String producerGroup) throws MQClientException {
        return SeataMQProducerFactory.createSingle(nameServer, null, producerGroup, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeataMQProducer createSingle(String nameServer, String namespace, String groupName, RPCHook rpcHook) throws MQClientException {
        if (defaultProducer != null) throw new NotSupportYetException("only one seata producer is permitted");
        Class<SeataMQProducerFactory> clazz = SeataMQProducerFactory.class;
        synchronized (SeataMQProducerFactory.class) {
            if (defaultProducer != null) throw new NotSupportYetException("only one seata producer is permitted");
            defaultProducer = new SeataMQProducer(namespace, groupName, rpcHook);
            defaultProducer.setNamesrvAddr(nameServer);
            TCCRocketMQ tccRocketMQProxy = ProxyUtil.createProxy(new TCCRocketMQImpl());
            tccRocketMQProxy.setProducer(defaultProducer);
            defaultProducer.setTccRocketMQ(tccRocketMQProxy);
            defaultProducer.start();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return defaultProducer;
        }
    }

    public static SeataMQProducer getProducer() {
        return defaultProducer;
    }
}

