/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.file;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.config.file.FileConfig;

@LoadLevel(name="CONF", scope=Scope.PROTOTYPE)
public class SimpleFileConfig
implements FileConfig {
    private Config fileConfig;

    public SimpleFileConfig() {
        this.fileConfig = ConfigFactory.load();
    }

    public SimpleFileConfig(File file, String name) {
        if (name.startsWith("file:")) {
            Config appConfig = ConfigFactory.parseFileAnySyntax((File)file);
            this.fileConfig = ConfigFactory.load((Config)appConfig);
        } else {
            this.fileConfig = ConfigFactory.load((String)file.getName());
        }
    }

    @Override
    public String getString(String path) {
        return this.fileConfig.getString(path);
    }

    @Override
    public Map<String, Object> getAllConfig() {
        return this.fileConfig.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(e.getKey(), ((ConfigValue)e.getValue()).unwrapped()), HashMap::putAll);
    }
}

