/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.ArrayUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.CycleDependencyHandler;
import org.apache.seata.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtils.class);
    private static final Pattern CAMEL_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern LINE_PATTERN = Pattern.compile("-(\\w)");
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    private StringUtils() {
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equalsIgnoreCase(b);
    }

    public static String inputStream2String(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            return "\"" + obj + "\"";
        }
        if (obj instanceof Character) {
            return "'" + obj + "'";
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            long time = date.getTime();
            String dateFormat = date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0 && time % 1000L == 0L ? "yyyy-MM-dd" : (time % 60000L == 0L ? "yyyy-MM-dd HH:mm" : (time % 1000L == 0L ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
            return new SimpleDateFormat(dateFormat).format(obj);
        }
        if (obj instanceof Enum) {
            return obj.getClass().getSimpleName() + "." + ((Enum)obj).name();
        }
        if (obj instanceof Class) {
            return ReflectionUtil.classToString((Class)obj);
        }
        if (obj instanceof Field) {
            return ReflectionUtil.fieldToString((Field)obj);
        }
        if (obj instanceof Method) {
            return ReflectionUtil.methodToString((Method)obj);
        }
        if (obj instanceof Annotation) {
            return ReflectionUtil.annotationToString((Annotation)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.toString((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return ArrayUtils.toString(obj);
        }
        if (obj instanceof Map) {
            return CollectionUtils.toString((Map)obj);
        }
        if (obj.getClass().getClassLoader() == null) {
            return obj.toString();
        }
        return CycleDependencyHandler.wrap(obj, o -> {
            Field[] fields;
            String classSimpleName;
            StringBuilder sb = new StringBuilder(32);
            if (obj.getClass().isAnonymousClass()) {
                classSimpleName = !obj.getClass().getSuperclass().equals(Object.class) ? obj.getClass().getSuperclass().getSimpleName() : obj.getClass().getInterfaces()[0].getSimpleName();
                classSimpleName = classSimpleName + "$";
            } else {
                classSimpleName = obj.getClass().getSimpleName();
            }
            sb.append(classSimpleName).append("(");
            int initialLength = sb.length();
            for (Field field : fields = ReflectionUtil.getAllFields(obj.getClass())) {
                field.setAccessible(true);
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append(field.getName());
                sb.append("=");
                try {
                    Object f = field.get(obj);
                    if (f == obj) {
                        sb.append("(this ").append(f.getClass().getSimpleName()).append(")");
                        continue;
                    }
                    sb.append(StringUtils.toString(f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(")");
            return sb.toString();
        });
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String hump2Line(String str) {
        Matcher matcher = CAMEL_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            matcher.appendReplacement(sb, "-" + matcher.group(0).toLowerCase());
            while (matcher.find()) {
                matcher.appendReplacement(sb, "-" + matcher.group(0).toLowerCase());
            }
        } else {
            matcher = LINE_PATTERN.matcher(str);
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean checkDataSize(String data, String dataName, int errorSize, boolean throwIfErr) {
        if (StringUtils.isBlank(data)) {
            return true;
        }
        int length = data.getBytes(StandardCharsets.UTF_8).length;
        if (length > errorSize) {
            LOGGER.warn("{} data is large(errorSize), size={}", (Object)dataName, (Object)length);
            if (!throwIfErr) {
                return false;
            }
            throw new IllegalArgumentException(dataName + " data is too large, size=" + length);
        }
        return true;
    }

    public static boolean hasLowerCase(String str) {
        if (null == str) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUpperCase(String str) {
        if (null == str) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? EMPTY : first.toString();
        }
        StringBuilder builder = new StringBuilder(256);
        if (first != null) {
            builder.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                builder.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            builder.append(obj);
        }
        return builder.toString();
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

