/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.result;

import java.io.Serializable;
import org.apache.seata.common.result.Code;
import org.apache.seata.common.result.Result;

public class SingleResult<T>
extends Result<T>
implements Serializable {
    private static final long serialVersionUID = 77612626624298767L;
    private T data;

    public SingleResult(String code, String message) {
        super(code, message);
    }

    public SingleResult(String code, String message, T data) {
        super(code, message);
        this.data = data;
    }

    public static <T> SingleResult<T> failure(String code, String msg) {
        return new SingleResult<T>(code, msg);
    }

    public static <T> SingleResult<T> failure(Code errorCode) {
        return new SingleResult<T>(errorCode.getCode(), errorCode.getMsg());
    }

    public static <T> SingleResult<T> success(T data) {
        return new SingleResult<T>("200", "success", data);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

