/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.result;

import java.io.Serializable;
import java.util.List;
import org.apache.seata.common.result.BaseParam;
import org.apache.seata.common.result.Result;

public class PageResult<T>
extends Result<T>
implements Serializable {
    private static final long serialVersionUID = 7761262662429121287L;
    private Integer pageSize;
    private Integer pageNum;
    private Integer total = 0;
    private Integer pages = 0;
    private List<T> data;

    public PageResult() {
    }

    public PageResult(String code, String message) {
        super(code, message);
    }

    public PageResult(List<T> data, Integer total, Integer pages, Integer pageNum, Integer pageSize) {
        super("200", "success");
        this.total = total;
        this.pages = pages;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.data = data;
    }

    public static <T> PageResult<T> build(List<T> list, Integer pageNum, Integer pageSize) {
        int pages = list.size() / pageSize;
        if (list.size() % pageSize != 0) {
            ++pages;
        }
        int offset = pageSize * (pageNum - 1);
        return PageResult.success(list.subList(Math.min(offset, list.size()), Math.min(offset + pageSize, list.size())), list.size(), pages, pageNum, pageSize);
    }

    public PageResult(List<T> data, Integer total, Integer pageNum, Integer pageSize) {
        super("200", "success");
        this.total = total;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.data = data;
        this.pages = total % pageSize == 0 ? Integer.valueOf(total / pageSize) : Integer.valueOf(total / pageSize + 1);
    }

    public static <T> PageResult<T> failure(String code, String msg) {
        return new PageResult<T>(code, msg);
    }

    public static <T> PageResult<T> success() {
        return new PageResult<T>("200", "success");
    }

    public static <T> PageResult<T> success(List<T> data, Integer total, Integer pages, Integer pageNum, Integer pageSize) {
        return new PageResult<T>(data, total, pages, pageNum, pageSize);
    }

    public static <T> PageResult<T> success(List<T> data, Integer total, Integer pageNum, Integer pageSize) {
        return new PageResult<T>(data, total, pageNum, pageSize);
    }

    public static void checkPage(BaseParam param) {
        if (param.getPageNum() <= 0) {
            param.setPageNum(1);
        }
        if (param.getPageSize() <= 0) {
            param.setPageSize(20);
        }
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getPages() {
        return this.pages;
    }

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getCurrPage() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }
}

