/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.utils;

import org.apache.rocketmq.schema.registry.common.exception.SchemaException;

public class ErrorMessage {
    public int status;
    public String message;

    public ErrorMessage(SchemaException exception) {
        this.status = exception.getErrorCode();
        this.message = exception.getMessage();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"status\":").append(this.status);
        sb.append(",\"message\":\"").append(this.message).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public static ErrorMessageBuilder builder() {
        return new ErrorMessageBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public ErrorMessage() {
    }

    public ErrorMessage(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public static class ErrorMessageBuilder {
        private int status;
        private String message;

        ErrorMessageBuilder() {
        }

        public ErrorMessageBuilder status(int status) {
            this.status = status;
            return this;
        }

        public ErrorMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorMessage build() {
            return new ErrorMessage(this.status, this.message);
        }

        public String toString() {
            return "ErrorMessage.ErrorMessageBuilder(status=" + this.status + ", message=" + this.message + ")";
        }
    }
}

