/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.properties;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.exception.SchemaException;

public class AclProperties {
    private boolean enabled;
    private String aclStr;
    private Map<QualifiedName, Set<String>> aclMap;

    public Map<QualifiedName, Set<String>> getAclMap() {
        if (this.aclMap == null) {
            this.aclMap = this.aclStr == null ? new HashMap() : AclProperties.buildAclMap(this.aclStr);
        }
        return this.aclMap;
    }

    @VisibleForTesting
    private static Map<QualifiedName, Set<String>> buildAclMap(String aclStr) {
        HashMap<QualifiedName, Set<String>> aclMap = new HashMap<QualifiedName, Set<String>>();
        try {
            for (String string : StringUtils.split((String)aclStr, (String)"|")) {
            }
        }
        catch (Exception e) {
            throw new SchemaException("Schema acl property parsing error", e);
        }
        return aclMap;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAclStr() {
        return this.aclStr;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAclStr(String aclStr) {
        this.aclStr = aclStr;
    }

    public void setAclMap(Map<QualifiedName, Set<String>> aclMap) {
        this.aclMap = aclMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AclProperties)) {
            return false;
        }
        AclProperties other = (AclProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$aclStr = this.getAclStr();
        String other$aclStr = other.getAclStr();
        if (this$aclStr == null ? other$aclStr != null : !this$aclStr.equals(other$aclStr)) {
            return false;
        }
        Map<QualifiedName, Set<String>> this$aclMap = this.getAclMap();
        Map<QualifiedName, Set<String>> other$aclMap = other.getAclMap();
        return !(this$aclMap == null ? other$aclMap != null : !((Object)this$aclMap).equals(other$aclMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AclProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $aclStr = this.getAclStr();
        result = result * 59 + ($aclStr == null ? 43 : $aclStr.hashCode());
        Map<QualifiedName, Set<String>> $aclMap = this.getAclMap();
        result = result * 59 + ($aclMap == null ? 43 : ((Object)$aclMap).hashCode());
        return result;
    }

    public String toString() {
        return "AclProperties(enabled=" + this.isEnabled() + ", aclStr=" + this.getAclStr() + ", aclMap=" + this.getAclMap() + ")";
    }
}

