/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.schema.registry.common.exception.SchemaException;
import org.apache.rocketmq.schema.registry.common.model.Dependency;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;
import org.apache.rocketmq.schema.registry.common.model.SubjectInfo;

public class SchemaRecordInfo
implements Serializable {
    private static final long serialVersionUID = 6215296681034788729L;
    private String schema;
    private long schemaId;
    private long version = 1L;
    private String idl;
    private Dependency dependency;
    private List<SubjectInfo> subjects = new ArrayList<SubjectInfo>();
    private SchemaType type;

    public void bindSubject(SubjectInfo subjectInfo) {
        this.getSubjects().add(subjectInfo);
    }

    public void unbindSubject(SubjectInfo subjectInfo) {
        this.getSubjects().remove(subjectInfo);
    }

    public SubjectInfo lastBindSubject() {
        if (this.getSubjects() == null) {
            throw new SchemaException("Schema record haven't bind any subject");
        }
        return this.getSubjects().get(this.subjects.size() - 1);
    }

    public String getSchema() {
        return this.schema;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public long getVersion() {
        return this.version;
    }

    public String getIdl() {
        return this.idl;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public List<SubjectInfo> getSubjects() {
        return this.subjects;
    }

    public SchemaType getType() {
        return this.type;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setSubjects(List<SubjectInfo> subjects) {
        this.subjects = subjects;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaRecordInfo)) {
            return false;
        }
        SchemaRecordInfo other = (SchemaRecordInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSchemaId() != other.getSchemaId()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$idl = this.getIdl();
        String other$idl = other.getIdl();
        if (this$idl == null ? other$idl != null : !this$idl.equals(other$idl)) {
            return false;
        }
        Dependency this$dependency = this.getDependency();
        Dependency other$dependency = other.getDependency();
        if (this$dependency == null ? other$dependency != null : !((Object)this$dependency).equals(other$dependency)) {
            return false;
        }
        List<SubjectInfo> this$subjects = this.getSubjects();
        List<SubjectInfo> other$subjects = other.getSubjects();
        if (this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects)) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaRecordInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $schemaId = this.getSchemaId();
        result = result * 59 + (int)($schemaId >>> 32 ^ $schemaId);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $idl = this.getIdl();
        result = result * 59 + ($idl == null ? 43 : $idl.hashCode());
        Dependency $dependency = this.getDependency();
        result = result * 59 + ($dependency == null ? 43 : ((Object)$dependency).hashCode());
        List<SubjectInfo> $subjects = this.getSubjects();
        result = result * 59 + ($subjects == null ? 43 : ((Object)$subjects).hashCode());
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaRecordInfo(schema=" + this.getSchema() + ", schemaId=" + this.getSchemaId() + ", version=" + this.getVersion() + ", idl=" + this.getIdl() + ", dependency=" + this.getDependency() + ", subjects=" + this.getSubjects() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public SchemaRecordInfo() {
    }

    public SchemaRecordInfo(String schema, long schemaId, long version, String idl, Dependency dependency, List<SubjectInfo> subjects, SchemaType type) {
        this.schema = schema;
        this.schemaId = schemaId;
        this.version = version;
        this.idl = idl;
        this.dependency = dependency;
        this.subjects = subjects;
        this.type = type;
    }
}

