/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.rocketmq.schema.registry.common.dto.BaseDto;

@ApiModel(description="Schema field/column information")
public class Field
extends BaseDto {
    private static final long serialVersionUID = -8336499483006254487L;
    @ApiModelProperty(value="Position of the field")
    private Integer pos;
    @ApiModelProperty(value="Name of the field", required=true)
    private String name;
    @ApiModelProperty(value="Type of the field", required=true)
    private String type;
    @ApiModelProperty(value="Comment of the field")
    private String comment;
    @ApiModelProperty(value="Can the field be null, default is true")
    private Boolean isNullable = true;
    @ApiModelProperty(value="Default value of the field")
    private String defaultValue;
    @ApiModelProperty(value="This filed sorted type, like: ascending, descending, ignore")
    private String sortType;
    @ApiModelProperty(value="Extra info of the field")
    private String extra;

    public static FieldBuilder builder() {
        return new FieldBuilder();
    }

    public Integer getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean getIsNullable() {
        return this.isNullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getSortType() {
        return this.sortType;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setPos(Integer pos) {
        this.pos = pos;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIsNullable(Boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public String toString() {
        return "Field(pos=" + this.getPos() + ", name=" + this.getName() + ", type=" + this.getType() + ", comment=" + this.getComment() + ", isNullable=" + this.getIsNullable() + ", defaultValue=" + this.getDefaultValue() + ", sortType=" + this.getSortType() + ", extra=" + this.getExtra() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pos = this.getPos();
        Integer other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !((Object)this$pos).equals(other$pos)) {
            return false;
        }
        Boolean this$isNullable = this.getIsNullable();
        Boolean other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$sortType = this.getSortType();
        String other$sortType = other.getSortType();
        if (this$sortType == null ? other$sortType != null : !this$sortType.equals(other$sortType)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : ((Object)$pos).hashCode());
        Boolean $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $sortType = this.getSortType();
        result = result * 59 + ($sortType == null ? 43 : $sortType.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    public Field() {
    }

    public Field(Integer pos, String name, String type, String comment, Boolean isNullable, String defaultValue, String sortType, String extra) {
        this.pos = pos;
        this.name = name;
        this.type = type;
        this.comment = comment;
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        this.sortType = sortType;
        this.extra = extra;
    }

    public static class FieldBuilder {
        private Integer pos;
        private String name;
        private String type;
        private String comment;
        private Boolean isNullable;
        private String defaultValue;
        private String sortType;
        private String extra;

        FieldBuilder() {
        }

        public FieldBuilder pos(Integer pos) {
            this.pos = pos;
            return this;
        }

        public FieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FieldBuilder type(String type) {
            this.type = type;
            return this;
        }

        public FieldBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public FieldBuilder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public FieldBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public FieldBuilder sortType(String sortType) {
            this.sortType = sortType;
            return this;
        }

        public FieldBuilder extra(String extra) {
            this.extra = extra;
            return this;
        }

        public Field build() {
            return new Field(this.pos, this.name, this.type, this.comment, this.isNullable, this.defaultValue, this.sortType, this.extra);
        }

        public String toString() {
            return "Field.FieldBuilder(pos=" + this.pos + ", name=" + this.name + ", type=" + this.type + ", comment=" + this.comment + ", isNullable=" + this.isNullable + ", defaultValue=" + this.defaultValue + ", sortType=" + this.sortType + ", extra=" + this.extra + ")";
        }
    }
}

