/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.config.JsonSerdeConfig;
import org.apache.rocketmq.schema.registry.client.exceptions.RestClientException;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.rest.JacksonMapper;
import org.apache.rocketmq.schema.registry.client.serde.Deserializer;
import org.apache.rocketmq.schema.registry.common.dto.GetSchemaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDeserializer<T>
implements Deserializer<T> {
    Logger log = LoggerFactory.getLogger(JsonDeserializer.class);
    private SchemaRegistryClient registryClient;
    private final ObjectMapper objectMapper = JacksonMapper.INSTANCE;
    private boolean skipSchemaRegistry;
    private Class<T> type;

    public JsonDeserializer() {
    }

    public JsonDeserializer(SchemaRegistryClient registryClient) {
        this.registryClient = registryClient;
    }

    @Override
    public void configure(Map<String, Object> configs) {
        JsonSerdeConfig serializerConfig = new JsonSerdeConfig(configs);
        this.skipSchemaRegistry = serializerConfig.skipSchemaRegistry();
        this.type = serializerConfig.deserializeTargetType();
    }

    @Override
    public T deserialize(String subject, byte[] payload) {
        if (null == payload || payload.length == 0) {
            return null;
        }
        if (this.skipSchemaRegistry) {
            if (null == this.type) {
                throw new SerializationException("type cannot be null");
            }
            try {
                return (T)this.objectMapper.readValue(payload, this.type);
            }
            catch (Exception e) {
                throw new SerializationException("JSON serialize failed", e);
            }
        }
        if (null == this.registryClient) {
            throw new SerializationException("please initialize the schema registry client first");
        }
        try {
            GetSchemaResponse response = this.registryClient.getSchemaBySubject(subject);
            ByteBuffer buffer = ByteBuffer.wrap(payload);
            long schemaRecordId = buffer.getLong();
            int length = buffer.limit() - 8;
            int start = buffer.position() + buffer.arrayOffset();
            JsonNode jsonNode = null;
            jsonNode = (JsonNode)this.objectMapper.readValue(buffer.array(), start, length, JsonNode.class);
            return (T)this.objectMapper.convertValue((Object)jsonNode, this.type);
        }
        catch (IOException | RestClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

