/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.rocketmq.schema.registry.client.config.AvroSerdeConfig;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.serde.Deserializer;

public class ReflectionAvroDeserializer<T>
implements Deserializer<T> {
    private Type type;

    @Override
    public void configure(Map<String, Object> configs) {
        AvroSerdeConfig avroSerdeConfig = new AvroSerdeConfig(configs);
        this.type = avroSerdeConfig.deserializeTargetType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T deserialize(String subject, byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        if (null == this.type) {
            throw new SerializationException("deserialize type can not be null");
        }
        Schema schema = ReflectData.get().getSchema(this.type);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object record;
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)bais, null);
            ReflectDatumReader datumReader = new ReflectDatumReader(schema);
            Object object = record = datumReader.read(null, (Decoder)decoder);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

