/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class MQAdmin {
    private static Logger log = Logger.getLogger(MQAdmin.class);

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum) {
        int defaultWaitTime = 5;
        return MQAdmin.createTopic(nameSrvAddr, clusterName, topic, queueNum, defaultWaitTime);
    }

    public static boolean createTopic(String nameSrvAddr, String clusterName, String topic, int queueNum, int waitTimeSec) {
        boolean createResult = false;
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setInstanceName(UUID.randomUUID().toString());
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        try {
            mqAdminExt.start();
            mqAdminExt.createTopic(clusterName, topic, queueNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long startTime = System.currentTimeMillis();
        while (!createResult) {
            createResult = MQAdmin.checkTopicExist(mqAdminExt, topic);
            if (System.currentTimeMillis() - startTime < (long)(waitTimeSec * 1000)) {
                TestUtils.waitForMoment(100L);
                continue;
            }
            log.error((Object)String.format("timeout,but create topic[%s] failed!", topic));
            break;
        }
        mqAdminExt.shutdown();
        return createResult;
    }

    private static boolean checkTopicExist(DefaultMQAdminExt mqAdminExt, String topic) {
        boolean createResult = false;
        try {
            TopicStatsTable topicInfo = mqAdminExt.examineTopicStats(topic);
            createResult = !topicInfo.getOffsetTable().isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return createResult;
    }

    public static boolean createSub(String nameSrvAddr, String clusterName, String consumerId) {
        boolean createResult = true;
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        SubscriptionGroupConfig config = new SubscriptionGroupConfig();
        config.setGroupName(consumerId);
        try {
            mqAdminExt.start();
            Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)mqAdminExt, (String)clusterName);
            for (String addr : masterSet) {
                try {
                    mqAdminExt.createAndUpdateSubscriptionGroupConfig(addr, config);
                    log.info((Object)String.format("create subscription group %s to %s success.\n", consumerId, addr));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            createResult = false;
            e.printStackTrace();
        }
        mqAdminExt.shutdown();
        return createResult;
    }

    public static ClusterInfo getCluster(String nameSrvAddr) {
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        ClusterInfo clusterInfo = null;
        try {
            mqAdminExt.start();
            clusterInfo = mqAdminExt.examineBrokerClusterInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mqAdminExt.shutdown();
        return clusterInfo;
    }

    public static boolean isBrokerExist(String ns, String ip) {
        ClusterInfo clusterInfo = MQAdmin.getCluster(ns);
        if (clusterInfo == null) {
            return false;
        }
        HashMap brokers = clusterInfo.getBrokerAddrTable();
        for (String brokerName : brokers.keySet()) {
            HashMap brokerIps = ((BrokerData)brokers.get(brokerName)).getBrokerAddrs();
            Iterator iterator = brokerIps.keySet().iterator();
            while (iterator.hasNext()) {
                long brokerId = (Long)iterator.next();
                if (!((String)brokerIps.get(brokerId)).contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    public void getSubConnection(String nameSrvAddr, String clusterName, String consumerId) {
        boolean createResult = true;
        DefaultMQAdminExt mqAdminExt = new DefaultMQAdminExt();
        mqAdminExt.setNamesrvAddr(nameSrvAddr);
        SubscriptionGroupConfig config = new SubscriptionGroupConfig();
        config.setGroupName(consumerId);
        try {
            mqAdminExt.start();
            Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)mqAdminExt, (String)clusterName);
            for (String addr : masterSet) {
                try {
                    System.out.printf("create subscription group %s to %s success.\n", consumerId, addr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            createResult = false;
            e.printStackTrace();
        }
        mqAdminExt.shutdown();
    }
}

