/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;

public class ConsumeQueue {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    public static final int CQ_STORE_UNIT_SIZE = 20;
    private static final InternalLogger LOG_ERROR = InternalLoggerFactory.getLogger((String)"RocketmqStoreError");
    private final DefaultMessageStore defaultMessageStore;
    private final MappedFileQueue mappedFileQueue;
    private final String topic;
    private final int queueId;
    private final ByteBuffer byteBufferIndex;
    private final String storePath;
    private final int mappedFileSize;
    private long maxPhysicOffset = -1L;
    private volatile long minLogicOffset = 0L;
    private ConsumeQueueExt consumeQueueExt = null;

    public ConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, DefaultMessageStore defaultMessageStore) {
        this.storePath = storePath;
        this.mappedFileSize = mappedFileSize;
        this.defaultMessageStore = defaultMessageStore;
        this.topic = topic;
        this.queueId = queueId;
        String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
        this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        this.byteBufferIndex = ByteBuffer.allocate(20);
        if (defaultMessageStore.getMessageStoreConfig().isEnableConsumeQueueExt()) {
            this.consumeQueueExt = new ConsumeQueueExt(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueueExt(defaultMessageStore.getMessageStoreConfig().getStorePathRootDir()), defaultMessageStore.getMessageStoreConfig().getMappedFileSizeConsumeQueueExt(), defaultMessageStore.getMessageStoreConfig().getBitMapLengthConsumeQueueExt());
        }
    }

    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("load consume queue " + this.topic + "-" + this.queueId + " " + (result ? "OK" : "Failed"));
        if (this.isExtReadEnable()) {
            result &= this.consumeQueueExt.load();
        }
        return result;
    }

    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long maxExtAddr;
            long mappedFileOffset;
            long processOffset;
            block7: {
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                int mappedFileSizeLogics = this.mappedFileSize;
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                maxExtAddr = 1L;
                while (true) {
                    for (int i = 0; i < mappedFileSizeLogics; i += 20) {
                        long offset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        long tagsCode = byteBuffer.getLong();
                        if (offset >= 0L && size > 0) {
                            mappedFileOffset = i + 20;
                            this.maxPhysicOffset = offset;
                            if (!this.isExtAddr(tagsCode)) continue;
                            maxExtAddr = tagsCode;
                            continue;
                        }
                        log.info("recover current consume queue file over,  " + mappedFile.getFileName() + " " + offset + " " + size + " " + tagsCode);
                        break;
                    }
                    if (mappedFileOffset != (long)mappedFileSizeLogics) break;
                    if (++index >= mappedFiles.size()) {
                        log.info("recover last consume queue file over, last mapped file " + mappedFile.getFileName());
                        break block7;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("recover next consume queue file, " + mappedFile.getFileName());
                }
                log.info("recover current consume queue queue over " + mappedFile.getFileName() + " " + (processOffset + mappedFileOffset));
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            if (this.isExtReadEnable()) {
                this.consumeQueueExt.recover();
                log.info("Truncate consume queue extend file by max {}", (Object)maxExtAddr);
                this.consumeQueueExt.truncateByMaxAddress(maxExtAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOffsetInQueueByTime(long timestamp) {
        MappedFile mappedFile = this.mappedFileQueue.getMappedFileByTime(timestamp);
        if (mappedFile != null) {
            long offset = 0L;
            int low = this.minLogicOffset > mappedFile.getFileFromOffset() ? (int)(this.minLogicOffset - mappedFile.getFileFromOffset()) : 0;
            int high = 0;
            int midOffset = -1;
            int targetOffset = -1;
            int leftOffset = -1;
            int rightOffset = -1;
            long leftIndexValue = -1L;
            long rightIndexValue = -1L;
            long minPhysicOffset = this.defaultMessageStore.getMinPhyOffset();
            SelectMappedBufferResult sbr = mappedFile.selectMappedBuffer(0);
            if (null != sbr) {
                ByteBuffer byteBuffer = sbr.getByteBuffer();
                high = byteBuffer.limit() - 20;
                try {
                    while (high >= low) {
                        midOffset = (low + high) / 40 * 20;
                        byteBuffer.position(midOffset);
                        long phyOffset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        if (phyOffset < minPhysicOffset) {
                            low = midOffset + 20;
                            leftOffset = midOffset;
                            continue;
                        }
                        long storeTime = this.defaultMessageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
                        if (storeTime < 0L) {
                            long l = 0L;
                            return l;
                        }
                        if (storeTime == timestamp) {
                            targetOffset = midOffset;
                            break;
                        }
                        if (storeTime > timestamp) {
                            high = midOffset - 20;
                            rightOffset = midOffset;
                            rightIndexValue = storeTime;
                            continue;
                        }
                        low = midOffset + 20;
                        leftOffset = midOffset;
                        leftIndexValue = storeTime;
                    }
                    offset = targetOffset != -1 ? (long)targetOffset : (leftIndexValue == -1L ? (long)rightOffset : (rightIndexValue == -1L ? (long)leftOffset : (Math.abs(timestamp - leftIndexValue) > Math.abs(timestamp - rightIndexValue) ? (long)rightOffset : (long)leftOffset)));
                    long l = (mappedFile.getFileFromOffset() + offset) / 20L;
                    return l;
                }
                finally {
                    sbr.release();
                }
            }
        }
        return 0L;
    }

    public void truncateDirtyLogicFiles(long phyOffet) {
        MappedFile mappedFile;
        int logicFileSize = this.mappedFileSize;
        this.maxPhysicOffset = phyOffet - 1L;
        long maxExtAddr = 1L;
        block0: while ((mappedFile = this.mappedFileQueue.getLastMappedFile()) != null) {
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            mappedFile.setWrotePosition(0);
            mappedFile.setCommittedPosition(0);
            mappedFile.setFlushedPosition(0);
            for (int i = 0; i < logicFileSize; i += 20) {
                int pos;
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                long tagsCode = byteBuffer.getLong();
                if (0 == i) {
                    if (offset >= phyOffet) {
                        this.mappedFileQueue.deleteLastMappedFile();
                        continue block0;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxPhysicOffset = offset;
                    if (!this.isExtAddr(tagsCode)) continue;
                    maxExtAddr = tagsCode;
                    continue;
                }
                if (offset >= 0L && size > 0) {
                    if (offset >= phyOffet) {
                        return;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxPhysicOffset = offset;
                    if (this.isExtAddr(tagsCode)) {
                        maxExtAddr = tagsCode;
                    }
                    if (pos != logicFileSize) continue;
                    return;
                }
                return;
            }
        }
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.truncateByMaxAddress(maxExtAddr);
        }
    }

    public long getLastOffset() {
        long lastOffset = -1L;
        int logicFileSize = this.mappedFileSize;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile != null) {
            int position = mappedFile.getWrotePosition() - 20;
            if (position < 0) {
                position = 0;
            }
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            byteBuffer.position(position);
            for (int i = 0; i < logicFileSize; i += 20) {
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (offset < 0L || size <= 0) break;
                lastOffset = offset + (long)size;
            }
        }
        return lastOffset;
    }

    public boolean flush(int flushLeastPages) {
        boolean result = this.mappedFileQueue.flush(flushLeastPages);
        if (this.isExtReadEnable()) {
            result &= this.consumeQueueExt.flush(flushLeastPages);
        }
        return result;
    }

    public int deleteExpiredFile(long offset) {
        int cnt = this.mappedFileQueue.deleteExpiredFileByOffset(offset, 20);
        this.correctMinOffset(offset);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctMinOffset(long phyMinOffset) {
        SelectMappedBufferResult result;
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        long minExtAddr = 1L;
        if (mappedFile != null && (result = mappedFile.selectMappedBuffer(0)) != null) {
            try {
                for (int i = 0; i < result.getSize(); i += 20) {
                    long offsetPy = result.getByteBuffer().getLong();
                    result.getByteBuffer().getInt();
                    long tagsCode = result.getByteBuffer().getLong();
                    if (offsetPy < phyMinOffset) continue;
                    this.minLogicOffset = result.getMappedFile().getFileFromOffset() + (long)i;
                    log.info("Compute logical min offset: {}, topic: {}, queueId: {}", new Object[]{this.getMinOffsetInQueue(), this.topic, this.queueId});
                    if (this.isExtAddr(tagsCode)) {
                        minExtAddr = tagsCode;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Exception thrown when correctMinOffset", (Throwable)e);
            }
            finally {
                result.release();
            }
        }
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.truncateByMinAddress(minExtAddr);
        }
    }

    public long getMinOffsetInQueue() {
        return this.minLogicOffset / 20L;
    }

    public void putMessagePositionInfoWrapper(DispatchRequest request) {
        int maxRetries = 30;
        boolean canWrite = this.defaultMessageStore.getRunningFlags().isCQWriteable();
        for (int i = 0; i < 30 && canWrite; ++i) {
            boolean result;
            long tagsCode = request.getTagsCode();
            if (this.isExtWriteEnable()) {
                ConsumeQueueExt.CqExtUnit cqExtUnit = new ConsumeQueueExt.CqExtUnit();
                cqExtUnit.setFilterBitMap(request.getBitMap());
                cqExtUnit.setMsgStoreTime(request.getStoreTimestamp());
                cqExtUnit.setTagsCode(request.getTagsCode());
                long extAddr = this.consumeQueueExt.put(cqExtUnit);
                if (this.isExtAddr(extAddr)) {
                    tagsCode = extAddr;
                } else {
                    log.warn("Save consume queue extend fail, So just save tagsCode! {}, topic:{}, queueId:{}, offset:{}", new Object[]{cqExtUnit, this.topic, this.queueId, request.getCommitLogOffset()});
                }
            }
            if (result = this.putMessagePositionInfo(request.getCommitLogOffset(), request.getMsgSize(), tagsCode, request.getConsumeQueueOffset())) {
                this.defaultMessageStore.getStoreCheckpoint().setLogicsMsgTimestamp(request.getStoreTimestamp());
                return;
            }
            log.warn("[BUG]put commit log position info to " + this.topic + ":" + this.queueId + " " + request.getCommitLogOffset() + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
        log.error("[BUG]consume queue can not write, {} {}", (Object)this.topic, (Object)this.queueId);
        this.defaultMessageStore.getRunningFlags().makeLogicsQueueError();
    }

    private boolean putMessagePositionInfo(long offset, int size, long tagsCode, long cqOffset) {
        if (offset <= this.maxPhysicOffset) {
            return true;
        }
        this.byteBufferIndex.flip();
        this.byteBufferIndex.limit(20);
        this.byteBufferIndex.putLong(offset);
        this.byteBufferIndex.putInt(size);
        this.byteBufferIndex.putLong(tagsCode);
        long expectLogicOffset = cqOffset * 20L;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(expectLogicOffset);
        if (mappedFile != null) {
            if (mappedFile.isFirstCreateInQueue() && cqOffset != 0L && mappedFile.getWrotePosition() == 0) {
                this.minLogicOffset = expectLogicOffset;
                this.mappedFileQueue.setFlushedWhere(expectLogicOffset);
                this.mappedFileQueue.setCommittedWhere(expectLogicOffset);
                this.fillPreBlank(mappedFile, expectLogicOffset);
                log.info("fill pre blank space " + mappedFile.getFileName() + " " + expectLogicOffset + " " + mappedFile.getWrotePosition());
            }
            if (cqOffset != 0L) {
                long currentLogicOffset = (long)mappedFile.getWrotePosition() + mappedFile.getFileFromOffset();
                if (expectLogicOffset < currentLogicOffset) {
                    log.warn("Build  consume queue repeatedly, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
                    return true;
                }
                if (expectLogicOffset != currentLogicOffset) {
                    LOG_ERROR.warn("[BUG]logic queue order maybe wrong, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
                }
            }
            this.maxPhysicOffset = offset;
            return mappedFile.appendMessage(this.byteBufferIndex.array());
        }
        return false;
    }

    private void fillPreBlank(MappedFile mappedFile, long untilWhere) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putLong(0L);
        byteBuffer.putInt(Integer.MAX_VALUE);
        byteBuffer.putLong(0L);
        int until = (int)(untilWhere % (long)this.mappedFileQueue.getMappedFileSize());
        for (int i = 0; i < until; i += 20) {
            mappedFile.appendMessage(byteBuffer.array());
        }
    }

    public SelectMappedBufferResult getIndexBuffer(long startIndex) {
        MappedFile mappedFile;
        int mappedFileSize = this.mappedFileSize;
        long offset = startIndex * 20L;
        if (offset >= this.getMinLogicOffset() && (mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset)) != null) {
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer((int)(offset % (long)mappedFileSize));
            return result;
        }
        return null;
    }

    public ConsumeQueueExt.CqExtUnit getExt(long offset) {
        if (this.isExtReadEnable()) {
            return this.consumeQueueExt.get(offset);
        }
        return null;
    }

    public boolean getExt(long offset, ConsumeQueueExt.CqExtUnit cqExtUnit) {
        if (this.isExtReadEnable()) {
            return this.consumeQueueExt.get(offset, cqExtUnit);
        }
        return false;
    }

    public long getMinLogicOffset() {
        return this.minLogicOffset;
    }

    public void setMinLogicOffset(long minLogicOffset) {
        this.minLogicOffset = minLogicOffset;
    }

    public long rollNextFile(long index) {
        int mappedFileSize = this.mappedFileSize;
        int totalUnitsInFile = mappedFileSize / 20;
        return index + (long)totalUnitsInFile - index % (long)totalUnitsInFile;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getMaxPhysicOffset() {
        return this.maxPhysicOffset;
    }

    public void setMaxPhysicOffset(long maxPhysicOffset) {
        this.maxPhysicOffset = maxPhysicOffset;
    }

    public void destroy() {
        this.maxPhysicOffset = -1L;
        this.minLogicOffset = 0L;
        this.mappedFileQueue.destroy();
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.destroy();
        }
    }

    public long getMessageTotalInQueue() {
        return this.getMaxOffsetInQueue() - this.getMinOffsetInQueue();
    }

    public long getMaxOffsetInQueue() {
        return this.mappedFileQueue.getMaxOffset() / 20L;
    }

    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.checkSelf();
        }
    }

    protected boolean isExtReadEnable() {
        return this.consumeQueueExt != null;
    }

    protected boolean isExtWriteEnable() {
        return this.consumeQueueExt != null && this.defaultMessageStore.getMessageStoreConfig().isEnableConsumeQueueExt();
    }

    public boolean isExtAddr(long tagsCode) {
        return ConsumeQueueExt.isExtAddr(tagsCode);
    }
}

