/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;

public class StructureServlet
extends AbstractServlet {
    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map<String, Object> structure = this.generateStructure((ConfiguredObject)this.getBroker(), (Class<? extends ConfiguredObject>)Broker.class);
        this.sendJsonResponse(structure, request, response);
    }

    private Map<String, Object> generateStructure(ConfiguredObject object, Class<? extends ConfiguredObject> clazz) {
        LinkedHashMap<String, Object> structure = new LinkedHashMap<String, Object>();
        structure.put("id", object.getId());
        structure.put("name", object.getName());
        for (Class childClass : object.getModel().getChildTypes(clazz)) {
            Collection children = object.getChildren(childClass);
            if (children == null) continue;
            ArrayList<Map<String, Object>> childObjects = new ArrayList<Map<String, Object>>();
            for (ConfiguredObject child : children) {
                childObjects.add(this.generateStructure(child, childClass));
            }
            if (childObjects.isEmpty()) continue;
            structure.put(this.pluralize(childClass), childObjects);
        }
        return structure;
    }

    private String pluralize(Class<? extends ConfiguredObject> childClass) {
        String name = childClass.getSimpleName().toLowerCase();
        return name + (name.endsWith("s") ? "es" : "s");
    }
}

