/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.management.plugin.HttpManagement;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.management.plugin.servlet.rest.ConfiguredObjectToMapConverter;
import org.apache.qpid.server.management.plugin.servlet.rest.NotFoundException;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfo;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfoParser;
import org.apache.qpid.server.management.plugin.servlet.rest.RestUserPreferenceHandler;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.OperationTimeoutException;
import org.apache.qpid.server.model.preferences.UserPreferences;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.util.DataUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServlet
extends AbstractServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServlet.class);
    private static final String HIERARCHY_INIT_PARAMETER = "hierarchy";
    public static final String DEPTH_PARAM = "depth";
    public static final String OVERSIZE_PARAM = "oversize";
    public static final String ACTUALS_PARAM = "actuals";
    public static final String SORT_PARAM = "sort";
    public static final String INCLUDE_SYS_CONTEXT_PARAM = "includeSysContext";
    public static final String INHERITED_ACTUALS_PARAM = "inheritedActuals";
    public static final String EXTRACT_INITIAL_CONFIG_PARAM = "extractInitialConfig";
    public static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    public static final String CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM = "contentDispositionAttachmentFilename";
    public static final Set<String> RESERVED_PARAMS = new HashSet<String>(Arrays.asList("depth", "sort", "oversize", "actuals", "includeSysContext", "extractInitialConfig", "inheritedActuals", "contentDispositionAttachmentFilename", "excludeInheritedContext"));
    public static final int DEFAULT_DEPTH = 1;
    public static final int DEFAULT_OVERSIZE = 120;
    private Class<? extends ConfiguredObject>[] _hierarchy;
    private final ConfiguredObjectToMapConverter _objectConverter = new ConfiguredObjectToMapConverter();
    private final boolean _hierarchyInitializationRequired;
    private volatile RequestInfoParser _requestInfoParser;
    private RestUserPreferenceHandler _userPreferenceHandler;

    public RestServlet() {
        this._hierarchyInitializationRequired = true;
    }

    public RestServlet(Class<? extends ConfiguredObject> ... hierarchy) {
        this._hierarchy = hierarchy;
        this._hierarchyInitializationRequired = false;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        if (this._hierarchyInitializationRequired) {
            this.doInitialization();
        }
        this._requestInfoParser = new RequestInfoParser(this._hierarchy);
        Handler.register();
        Long preferenceOperationTimeout = (Long)this.getManagementConfiguration().getContextValue(Long.class, "qpid.httpManagement.preferenceOperationTimeout");
        this._userPreferenceHandler = new RestUserPreferenceHandler(preferenceOperationTimeout == null ? 10000L : preferenceOperationTimeout);
    }

    private void doInitialization() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String hierarchy = config.getInitParameter(HIERARCHY_INIT_PARAMETER);
        if (hierarchy != null && !"".equals(hierarchy)) {
            String[] hierarchyItems;
            ArrayList classes = new ArrayList();
            for (String item : hierarchyItems = hierarchy.split(",")) {
                Class<?> itemClass;
                try {
                    itemClass = Class.forName(item);
                }
                catch (ClassNotFoundException e) {
                    try {
                        itemClass = Class.forName("org.apache.qpid.server.model." + item);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new ServletException("Unknown configured object class '" + item + "' is specified in hierarchy for " + config.getServletName());
                    }
                }
                Class<?> clazz = itemClass;
                classes.add(clazz);
            }
            Class[] hierarchyClasses = new Class[classes.size()];
            this._hierarchy = classes.toArray(hierarchyClasses);
        } else {
            this._hierarchy = new Class[0];
        }
    }

    private Collection<ConfiguredObject<?>> getTargetObjects(RequestInfo requestInfo, List<Predicate<ConfiguredObject<?>>> filterPredicateList) {
        List<String> names = requestInfo.getModelParts();
        ArrayList<Object> parents = new ArrayList();
        parents.add(this.getBroker());
        ArrayList<ConfiguredObject> children = new ArrayList<ConfiguredObject>();
        HashMap<Class<? extends ConfiguredObject>, String> filters = new HashMap<Class<? extends ConfiguredObject>, String>();
        Model model = this.getBroker().getModel();
        boolean wildcard = false;
        Class<Broker> parentType = Broker.class;
        for (int i = 0; i < this._hierarchy.length; ++i) {
            if (model.getChildTypes(parentType).contains(this._hierarchy[i])) {
                parentType = this._hierarchy[i];
                for (ConfiguredObject configuredObject : parents) {
                    if (names.size() > i && names.get(i) != null && !names.get(i).equals("*") && names.get(i).trim().length() != 0) {
                        for (ConfiguredObject child : configuredObject.getChildren(this._hierarchy[i])) {
                            if (!child.getName().equals(names.get(i))) continue;
                            children.add(child);
                        }
                        if (!children.isEmpty()) continue;
                        return null;
                    }
                    wildcard = true;
                    children.addAll(configuredObject.getChildren(this._hierarchy[i]));
                }
            } else {
                children = parents;
                if (names.size() > i && names.get(i) != null && !names.get(i).equals("*") && names.get(i).trim().length() != 0) {
                    filters.put(this._hierarchy[i], names.get(i));
                } else {
                    wildcard = true;
                }
            }
            parents = children;
            children = new ArrayList();
        }
        if (!filters.isEmpty() && !parents.isEmpty()) {
            ArrayList potentials = parents;
            parents = new ArrayList();
            for (ConfiguredObject configuredObject : potentials) {
                boolean match = true;
                for (Map.Entry entry : filters.entrySet()) {
                    Collection<? extends ConfiguredObject> ancestors = this.getAncestors(this.getConfiguredClass(), (Class)entry.getKey(), configuredObject);
                    match = false;
                    for (ConfiguredObject configuredObject2 : ancestors) {
                        if (!configuredObject2.getName().equals(entry.getValue())) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    break;
                }
                if (!match) continue;
                parents.add(configuredObject);
            }
        }
        if (parents.isEmpty() && !wildcard) {
            return null;
        }
        if (filterPredicateList.isEmpty()) {
            return parents;
        }
        Iterator iter = parents.iterator();
        block6: while (iter.hasNext()) {
            ConfiguredObject obj = (ConfiguredObject)iter.next();
            for (Predicate<ConfiguredObject<?>> predicate : filterPredicateList) {
                if (predicate.apply((Object)obj)) continue;
                iter.remove();
                continue block6;
            }
        }
        return parents;
    }

    private List<Predicate<ConfiguredObject<?>>> buildFilterPredicates(HttpServletRequest request) {
        ArrayList<1> predicates = new ArrayList<1>();
        for (final String paramName : Collections.list(request.getParameterNames())) {
            if (RESERVED_PARAMS.contains(paramName)) continue;
            final List<String> allowedValues = Arrays.asList(request.getParameterValues(paramName));
            predicates.add(new Predicate<ConfiguredObject<?>>(){

                public boolean apply(ConfiguredObject<?> obj) {
                    Object value = obj.getAttribute(paramName);
                    return allowedValues.contains(String.valueOf(value));
                }
            });
        }
        return Collections.unmodifiableList(predicates);
    }

    private Collection<? extends ConfiguredObject> getAncestors(Class<? extends ConfiguredObject> childType, Class<? extends ConfiguredObject> ancestorType, ConfiguredObject child) {
        HashSet<Object> ancestors = new HashSet<Object>();
        Collection parentTypes = child.getModel().getParentTypes(childType);
        for (Class parentClazz : parentTypes) {
            ConfiguredObject parent;
            if (parentClazz == ancestorType) {
                parent = child.getParent(parentClazz);
                if (parent == null) continue;
                ancestors.add(parent);
                continue;
            }
            parent = child.getParent(parentClazz);
            if (parent == null) continue;
            ancestors.addAll(this.getAncestors(parentClazz, ancestorType, parent));
        }
        return ancestors;
    }

    @Override
    protected void doGetWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo requestInfo = this._requestInfoParser.parse(request);
        switch (requestInfo.getType()) {
            case OPERATION: {
                this.doOperation(requestInfo, request, response);
                break;
            }
            case MODEL_OBJECT: {
                boolean excludeInheritedContext;
                Collection<ConfiguredObject<?>> allObjects;
                String attachmentFilename = request.getParameter(CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM);
                if (attachmentFilename != null) {
                    this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
                }
                if ((allObjects = this.getTargetObjects(requestInfo, this.buildFilterPredicates(request))) == null || allObjects.isEmpty() && this.isSingleObjectRequest(requestInfo)) {
                    this.sendJsonErrorResponse(request, response, 404, "Not Found");
                    return;
                }
                int depth = this.getIntParameterFromRequest(request, DEPTH_PARAM, 1);
                int oversizeThreshold = this.getIntParameterFromRequest(request, OVERSIZE_PARAM, 120);
                boolean actuals = this.getBooleanParameterFromRequest(request, ACTUALS_PARAM);
                String includeSystemContextParameter = request.getParameter(INCLUDE_SYS_CONTEXT_PARAM);
                String inheritedActualsParameter = request.getParameter(INHERITED_ACTUALS_PARAM);
                String excludeInheritedContextParameter = request.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM);
                if (excludeInheritedContextParameter == null) {
                    excludeInheritedContext = inheritedActualsParameter == null && includeSystemContextParameter == null ? actuals : (inheritedActualsParameter != null && includeSystemContextParameter != null ? (actuals ? !Boolean.parseBoolean(inheritedActualsParameter) : !Boolean.parseBoolean(includeSystemContextParameter)) : (inheritedActualsParameter != null ? (actuals ? !Boolean.parseBoolean(inheritedActualsParameter) : false) : (actuals ? true : !Boolean.parseBoolean(includeSystemContextParameter))));
                } else {
                    if (inheritedActualsParameter != null || includeSystemContextParameter != null) {
                        this.sendJsonErrorResponse(request, response, 422, String.format("Parameter '%s' cannot be specified together with '%s' or '%s'", EXCLUDE_INHERITED_CONTEXT_PARAM, INHERITED_ACTUALS_PARAM, INCLUDE_SYS_CONTEXT_PARAM));
                        return;
                    }
                    excludeInheritedContext = Boolean.parseBoolean(excludeInheritedContextParameter);
                }
                ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
                for (ConfiguredObject<?> configuredObject : allObjects) {
                    output.add(this._objectConverter.convertObjectToMap(configuredObject, this.getConfiguredClass(), new ConfiguredObjectToMapConverter.ConverterOptions(depth, actuals, oversizeThreshold, request.isSecure(), excludeInheritedContext)));
                }
                boolean sendCachingHeaders = attachmentFilename == null;
                this.sendJsonResponse(output, request, response, 200, sendCachingHeaders);
                break;
            }
            case VISIBLE_PREFERENCES: 
            case USER_PREFERENCES: {
                this.doGetUserPreferences(requestInfo, request, response);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{requestInfo.getType(), request.getPathInfo()}));
            }
        }
    }

    private boolean isSingleObjectRequest(RequestInfo requestInfo) {
        if (this._hierarchy.length > 0) {
            List<String> pathInfoElements = requestInfo.getModelParts();
            return pathInfoElements.size() == this._hierarchy.length;
        }
        return false;
    }

    private void setContentDispositionHeaderIfNecessary(HttpServletResponse response, String attachmentFilename) {
        if (attachmentFilename != null) {
            String filenameRfc2183 = HttpManagementUtil.ensureFilenameIsRfc2183(attachmentFilename);
            if (filenameRfc2183.length() > 0) {
                response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", filenameRfc2183));
            } else {
                response.setHeader("Content-disposition", "attachment");
            }
        }
    }

    private Class<? extends ConfiguredObject> getConfiguredClass() {
        return this._hierarchy.length == 0 ? Broker.class : this._hierarchy[this._hierarchy.length - 1];
    }

    @Override
    protected void doPutWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        catch (IllegalArgumentException | IllegalStateException | NoClassDefFoundError | SecurityException | IllegalConfigurationException | IllegalStateTransitionException | IntegrityViolationException | OperationTimeoutException e) {
            this.setResponseStatus(request, response, e);
        }
    }

    private void performCreateOrUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        RequestInfo requestInfo = this._requestInfoParser.parse(request);
        switch (requestInfo.getType()) {
            case MODEL_OBJECT: {
                ConfiguredObject<?> configuredObject;
                List<String> names = requestInfo.getModelParts();
                boolean isFullObjectURL = names.size() == this._hierarchy.length;
                Map<String, Object> providedObject = this.getRequestProvidedObject(request, requestInfo);
                if (names.isEmpty() && this._hierarchy.length == 0) {
                    this.getBroker().setAttributes(providedObject);
                    response.setStatus(200);
                    return;
                }
                ConfiguredObject theParent = this.getBroker();
                ConfiguredObject[] otherParents = null;
                Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
                if (this._hierarchy.length > 1) {
                    List<ConfiguredObject> parents = this.findAllObjectParents(names);
                    theParent = parents.remove(0);
                    otherParents = parents.toArray(new ConfiguredObject[parents.size()]);
                }
                if (isFullObjectURL) {
                    providedObject.put("name", names.get(names.size() - 1));
                    configuredObject = this.findObjectToUpdateInParent(objClass, providedObject, theParent, otherParents);
                    if (configuredObject != null) {
                        configuredObject.setAttributes(providedObject);
                        response.setStatus(200);
                        return;
                    }
                    if ("POST".equalsIgnoreCase(request.getMethod())) {
                        this.sendJsonErrorResponse(request, response, 404, "Object with " + (providedObject.containsKey("id") ? " id '" + providedObject.get("id") : " name '" + providedObject.get("name")) + "' does not exist!");
                        return;
                    }
                }
                configuredObject = theParent.createChild(objClass, providedObject, otherParents);
                StringBuffer requestURL = request.getRequestURL();
                if (!isFullObjectURL) {
                    requestURL.append("/").append(configuredObject.getName());
                }
                response.setHeader("Location", requestURL.toString());
                response.setStatus(201);
                break;
            }
            case OPERATION: {
                this.doOperation(requestInfo, request, response);
                break;
            }
            case USER_PREFERENCES: {
                this.doPostOrPutUserPreference(requestInfo, request, response);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected request type '%s' for path '%s'", new Object[]{requestInfo.getType(), request.getPathInfo()}));
            }
        }
    }

    private void doGetUserPreferences(RequestInfo requestInfo, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object responseObject;
        Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(requestInfo, Collections.emptyList());
        if (allObjects == null || allObjects.isEmpty() && this.isSingleObjectRequest(requestInfo)) {
            this.sendJsonErrorResponse(request, response, 404, "Not Found");
            return;
        }
        if (requestInfo.hasWildcard()) {
            responseObject = new ArrayList(allObjects.size());
            for (ConfiguredObject<?> target : allObjects) {
                UserPreferences userPreferences = target.getUserPreferences();
                try {
                    Object preferences = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
                    if (preferences == null || preferences instanceof Collection && ((Collection)preferences).isEmpty() || preferences instanceof Map && ((Map)preferences).isEmpty()) continue;
                    ((List)responseObject).add(preferences);
                }
                catch (NotFoundException notFoundException) {}
            }
        } else {
            ConfiguredObject<?> target = allObjects.iterator().next();
            UserPreferences userPreferences = target.getUserPreferences();
            responseObject = this._userPreferenceHandler.handleGET(userPreferences, requestInfo);
        }
        this.sendJsonResponse(responseObject, request, response);
    }

    private void doPostOrPutUserPreference(RequestInfo requestInfo, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConfiguredObject<?> target = this.getTarget(requestInfo);
        Object providedObject = this.getRequestProvidedObject(request, requestInfo, Object.class);
        if ("POST".equals(request.getMethod())) {
            this._userPreferenceHandler.handlePOST(target, requestInfo, providedObject);
        } else if ("PUT".equals(request.getMethod())) {
            this._userPreferenceHandler.handlePUT(target, requestInfo, providedObject);
        } else {
            this.sendJsonErrorResponse(request, response, 500, "unexpected http method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperation(RequestInfo requestInfo, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map<String, Object> operationArguments;
        ConfiguredObject<?> target = this.getTarget(requestInfo);
        if (target == null) {
            return;
        }
        String operationName = requestInfo.getOperationName();
        Map availableOperations = this.getBroker().getModel().getTypeRegistry().getOperations(target.getClass());
        ConfiguredObjectOperation operation = (ConfiguredObjectOperation)availableOperations.get(operationName);
        String requestMethod = request.getMethod();
        if (operation == null) {
            this.sendJsonErrorResponse(request, response, 404, "No such operation: " + operationName);
            return;
        }
        switch (requestMethod) {
            case "GET": {
                if (operation.isNonModifying()) {
                    operationArguments = this.getOperationArgumentsAsMap(request);
                    operationArguments.keySet().removeAll(Arrays.asList(CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM));
                    break;
                }
                response.addHeader("Allow", "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " modifies the object so you must use POST.");
                return;
            }
            case "POST": {
                operationArguments = this.getRequestProvidedObject(request, requestInfo);
                break;
            }
            default: {
                response.addHeader("Allow", operation.isNonModifying() ? "POST, GET" : "POST");
                this.sendJsonErrorResponse(request, response, 405, "Operation " + operationName + " does not support the " + requestMethod + " requestMethod.");
                return;
            }
        }
        if (operation.isSecure(target, operationArguments) && !request.isSecure() && !HttpManagement.getPort(request).isAllowConfidentialOperationsOnInsecureChannels()) {
            this.sendJsonErrorResponse(request, response, 403, "Operation '" + operationName + "' can only be performed over a secure (HTTPS) connection");
            return;
        }
        Map<String, Object> returnVal = operation.perform(target, operationArguments);
        if (returnVal instanceof Content) {
            Content content = (Content)returnVal;
            try {
                this.writeTypedContent(content, request, response);
            }
            finally {
                content.release();
            }
        } else {
            ConfiguredObjectToMapConverter.ConverterOptions converterOptions = new ConfiguredObjectToMapConverter.ConverterOptions(1, false, 120, request.isSecure(), true);
            if (ConfiguredObject.class.isAssignableFrom(operation.getReturnType())) {
                returnVal = this._objectConverter.convertObjectToMap((ConfiguredObject)returnVal, operation.getReturnType(), converterOptions);
            } else if (this.returnsCollectionOfConfiguredObjects(operation)) {
                ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
                for (Object configuredObject : (Collection)((Object)returnVal)) {
                    output.add(this._objectConverter.convertObjectToMap((ConfiguredObject)configuredObject, this.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType()), converterOptions));
                }
                returnVal = output;
            }
            String attachmentFilename = request.getParameter(CONTENT_DISPOSITION_ATTACHMENT_FILENAME_PARAM);
            if (attachmentFilename != null) {
                this.setContentDispositionHeaderIfNecessary(response, attachmentFilename);
            }
            this.sendJsonResponse(returnVal, request, response);
        }
    }

    private ConfiguredObject<?> getTarget(RequestInfo requestInfo) throws IOException {
        Broker<?> target;
        List<String> names = requestInfo.getModelParts();
        if (names.isEmpty() && this._hierarchy.length == 0) {
            target = this.getBroker();
        } else {
            Map<String, Object> objectName;
            Class<? extends ConfiguredObject> objClass;
            ConfiguredObject theParent = this.getBroker();
            ConfiguredObject[] otherParents = null;
            if (this._hierarchy.length > 1) {
                List<ConfiguredObject> parents = this.findAllObjectParents(names);
                theParent = parents.remove(0);
                otherParents = parents.toArray(new ConfiguredObject[parents.size()]);
            }
            if ((target = this.findObjectToUpdateInParent(objClass = this.getConfiguredClass(), objectName = Collections.singletonMap("name", names.get(names.size() - 1)), theParent, otherParents)) == null) {
                String errorMessage = String.format("%s '%s' not found", this.getConfiguredClass().getSimpleName(), Joiner.on((String)"/").join(names));
                throw new NotFoundException(errorMessage);
            }
        }
        return target;
    }

    private boolean returnsCollectionOfConfiguredObjects(ConfiguredObjectOperation operation) {
        return Collection.class.isAssignableFrom(operation.getReturnType()) && operation.getGenericReturnType() instanceof ParameterizedType && ConfiguredObject.class.isAssignableFrom(this.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType()));
    }

    private Class getCollectionMemberType(ParameterizedType collectionType) {
        return RestServlet.getRawType(collectionType.getActualTypeArguments()[0]);
    }

    private static Class getRawType(Type t) {
        Type[] upperBounds;
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)t).getBounds();
            if (bounds.length == 1) {
                return RestServlet.getRawType(bounds[0]);
            }
        } else if (t instanceof WildcardType && (upperBounds = ((WildcardType)t).getUpperBounds()).length == 1) {
            return RestServlet.getRawType(upperBounds[0]);
        }
        throw new ServerScopedRuntimeException("Unable to process type when constructing configuration model: " + t);
    }

    private Map<String, Object> getOperationArgumentsAsMap(HttpServletRequest request) {
        HashMap<String, Object> providedObject = new HashMap<String, Object>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value == null) continue;
            if (value.length > 1) {
                providedObject.put((String)entry.getKey(), Arrays.asList(value));
                continue;
            }
            providedObject.put((String)entry.getKey(), value[0]);
        }
        return providedObject;
    }

    private List<ConfiguredObject> findAllObjectParents(List<String> names) {
        Collection[] objects = new Collection[this._hierarchy.length];
        block0: for (int i = 0; i < this._hierarchy.length - 1; ++i) {
            objects[i] = new HashSet();
            if (i == 0) {
                for (ConfiguredObject object : this.getBroker().getChildren(this._hierarchy[0])) {
                    if (!object.getName().equals(names.get(0))) continue;
                    objects[0].add(object);
                    continue block0;
                }
                continue;
            }
            for (int j = i - 1; j >= 0; --j) {
                if (!this.getBroker().getModel().getChildTypes(this._hierarchy[j]).contains(this._hierarchy[i])) continue;
                for (ConfiguredObject parent : objects[j]) {
                    for (ConfiguredObject object : parent.getChildren(this._hierarchy[i])) {
                        if (!object.getName().equals(names.get(i))) continue;
                        objects[i].add(object);
                    }
                }
                continue block0;
            }
        }
        ArrayList<ConfiguredObject> parents = new ArrayList<ConfiguredObject>();
        Class<? extends ConfiguredObject> objClass = this.getConfiguredClass();
        Collection parentClasses = this.getBroker().getModel().getParentTypes(objClass);
        for (int i = this._hierarchy.length - 2; i >= 0; --i) {
            if (!parentClasses.contains(this._hierarchy[i])) continue;
            if (objects[i].size() == 1) {
                parents.add((ConfiguredObject)objects[i].iterator().next());
                continue;
            }
            throw new IllegalArgumentException("Cannot deduce parent of class " + this._hierarchy[i].getSimpleName());
        }
        return parents;
    }

    private Map<String, Object> getRequestProvidedObject(HttpServletRequest request, RequestInfo requestInfo) throws IOException, ServletException {
        return this.getRequestProvidedObject(request, requestInfo, LinkedHashMap.class);
    }

    private <T> T getRequestProvidedObject(HttpServletRequest request, RequestInfo requestInfo, Class<T> expectedClass) throws IOException, ServletException {
        Object providedObject;
        ArrayList headers = Collections.list(request.getHeaderNames());
        ObjectMapper mapper = new ObjectMapper();
        if (headers.contains("Content-Type") && request.getHeader("Content-Type").startsWith("multipart/form-data")) {
            providedObject = new LinkedHashMap();
            HashMap<String, String> fileUploads = new HashMap<String, String>();
            Collection parts = request.getParts();
            for (Part part : parts) {
                if ("data".equals(part.getName()) && "application/json".equals(part.getContentType())) {
                    try {
                        providedObject = mapper.readValue(part.getInputStream(), LinkedHashMap.class);
                        continue;
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalArgumentException("Cannot parse the operation body as json", e);
                    }
                }
                byte[] data = new byte[(int)part.getSize()];
                part.getInputStream().read(data);
                String inlineURL = DataUrlUtils.getDataUrlForBytes((byte[])data);
                fileUploads.put(part.getName(), inlineURL);
            }
            ((Map)providedObject).putAll(fileUploads);
        } else {
            try {
                providedObject = mapper.readValue((InputStream)request.getInputStream(), expectedClass);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Cannot parse the operation body as json", e);
            }
        }
        return (T)providedObject;
    }

    private ConfiguredObject<?> findObjectToUpdateInParent(Class<? extends ConfiguredObject> objClass, Map<String, Object> providedObject, ConfiguredObject theParent, ConfiguredObject[] otherParents) {
        Collection existingChildren = theParent.getChildren(objClass);
        for (ConfiguredObject obj : existingChildren) {
            if ((!providedObject.containsKey("id") || !String.valueOf(providedObject.get("id")).equals(obj.getId().toString())) && (!obj.getName().equals(providedObject.get("name")) || !this.sameOtherParents(obj, otherParents, objClass))) continue;
            return obj;
        }
        return null;
    }

    private boolean sameOtherParents(ConfiguredObject obj, ConfiguredObject[] otherParents, Class<? extends ConfiguredObject> objClass) {
        Collection parentClasses = obj.getModel().getParentTypes(objClass);
        if (otherParents == null || otherParents.length == 0) {
            return parentClasses.size() == 1;
        }
        for (ConfiguredObject parent : otherParents) {
            boolean found = false;
            for (Class parentClass : parentClasses) {
                if (parent != obj.getParent(parentClass)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void setResponseStatus(HttpServletRequest request, HttpServletResponse response, Throwable e) throws IOException {
        if (e instanceof SecurityException) {
            LOGGER.debug("{}, sending {}", new Object[]{e.getClass().getName(), 403, e});
            response.setStatus(403);
        } else {
            int responseCode = 400;
            String message = e.getMessage();
            if (e instanceof AbstractConfiguredObject.DuplicateIdException || e instanceof AbstractConfiguredObject.DuplicateNameException || e instanceof IntegrityViolationException || e instanceof IllegalStateTransitionException) {
                responseCode = 409;
            } else if (e instanceof NotFoundException) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getClass().getSimpleName() + " processing request", e);
                }
                responseCode = 404;
            } else if (e instanceof IllegalConfigurationException || e instanceof IllegalArgumentException) {
                LOGGER.warn("{} processing request {} from user '{}': {}", new Object[]{e.getClass().getSimpleName(), HttpManagementUtil.getRequestURL(request), HttpManagementUtil.getRequestPrincipals(request), message});
                Throwable t = e;
                int maxDepth = 10;
                while ((t = t.getCause()) != null && maxDepth-- != 0) {
                    LOGGER.warn("... caused by " + t.getClass().getSimpleName() + "  : " + t.getMessage());
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(e.getClass().getSimpleName() + " processing request", e);
                }
                responseCode = 422;
            } else if (e instanceof OperationTimeoutException) {
                message = "Timeout occurred";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Timeout during processing of request {} from user '{}'", new Object[]{HttpManagementUtil.getRequestURL(request), HttpManagementUtil.getRequestPrincipals(request), e});
                } else {
                    LOGGER.info("Timeout during processing of request {} from user '{}'", (Object)HttpManagementUtil.getRequestURL(request), (Object)HttpManagementUtil.getRequestPrincipals(request));
                }
                responseCode = 502;
            } else if (e instanceof NoClassDefFoundError) {
                message = "Not found: " + message;
                LOGGER.warn("Unexpected exception processing request ", e);
            } else {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unexpected Exception", e);
            }
            this.sendJsonErrorResponse(request, response, responseCode, message);
        }
    }

    @Override
    protected void doDeleteWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo requestInfo = this._requestInfoParser.parse(request);
        Collection<ConfiguredObject<?>> allObjects = this.getTargetObjects(requestInfo, this.buildFilterPredicates(request));
        if (allObjects == null) {
            throw new NotFoundException("Not Found");
        }
        switch (requestInfo.getType()) {
            case MODEL_OBJECT: {
                for (ConfiguredObject<?> o : allObjects) {
                    o.delete();
                }
                this.sendCachingHeadersOnResponse(response);
                response.setStatus(200);
                break;
            }
            case USER_PREFERENCES: {
                if (allObjects.size() > 1) {
                    this.sendJsonErrorResponse(request, response, 400, "Deletion of user preferences using wildcards is unsupported");
                    return;
                }
                for (ConfiguredObject<?> o : allObjects) {
                    this._userPreferenceHandler.handleDELETE(o.getUserPreferences(), requestInfo);
                }
                break;
            }
            default: {
                this.sendJsonErrorResponse(request, response, 400, "Unsupported delete call");
            }
        }
    }

    @Override
    protected void doPostWithSubjectAndActor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.performCreateOrUpdate(request, response);
    }

    private int getIntParameterFromRequest(HttpServletRequest request, String paramName, int defaultValue) {
        int intValue = defaultValue;
        String stringValue = request.getParameter(paramName);
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse " + stringValue + " as integer for parameter " + paramName);
            }
        }
        return intValue;
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName) {
        return this.getBooleanParameterFromRequest(request, paramName, false);
    }

    private boolean getBooleanParameterFromRequest(HttpServletRequest request, String paramName, boolean defaultValue) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

