/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;

public class DefinedFileServlet
extends HttpServlet {
    private static final String FILENAME_INIT_PARAMETER = "filename";
    private final String _expectedPath;
    private final String _apiDocsPath;
    private String _filename;

    public DefinedFileServlet() {
        this(null);
    }

    public DefinedFileServlet(String filename) {
        this(filename, null, null);
    }

    public DefinedFileServlet(String filename, String expectedPath, String apiDocsPath) {
        this._filename = filename;
        this._expectedPath = expectedPath;
        this._apiDocsPath = apiDocsPath;
    }

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String fileName = config.getInitParameter(FILENAME_INIT_PARAMETER);
        if (fileName != null && !"".equals(fileName)) {
            this._filename = fileName;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block40: {
            String path = request.getServletPath();
            if (this._expectedPath == null || this._expectedPath.equals(path == null ? "" : path)) {
                try (OutputStream output = HttpManagementUtil.getOutputStream(request, response);
                     InputStream fileInput = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/" + this._filename);){
                    if (fileInput != null) {
                        byte[] buffer = new byte[1024];
                        response.setStatus(200);
                        int read = 0;
                        while ((read = fileInput.read(buffer)) > 0) {
                            output.write(buffer, 0, read);
                        }
                    } else {
                        response.sendError(404, "unknown file: " + this._filename);
                    }
                    break block40;
                }
            }
            response.setStatus(404);
            try (OutputStream output = HttpManagementUtil.getOutputStream(request, response);){
                String notFoundMessage = "Unknown path '" + request.getServletPath() + "'. Please read the api docs at " + request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + this._apiDocsPath + "\n";
                output.write(notFoundMessage.getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

