/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.connector;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.server.AsyncHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslCertificates;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TcpAndSslSelectChannelConnector
extends SelectChannelConnector {
    private static final Logger LOG = Log.getLogger(TcpAndSslSelectChannelConnector.class);
    private final SslContextFactory _sslContextFactory;

    public TcpAndSslSelectChannelConnector(SslContextFactory factory) {
        this._sslContextFactory = factory;
        this.addBean(this._sslContextFactory);
        this.setUseDirectBuffers(false);
        this.setSoLingerTime(30000);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        if (endpoint instanceof SslConnection.SslEndPoint) {
            request.setScheme("https");
        }
        super.customize(endpoint, request);
        if (endpoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndpoint = (SslConnection.SslEndPoint)endpoint;
            SSLEngine sslEngine = sslEndpoint.getSslEngine();
            SSLSession sslSession = sslEngine.getSession();
            SslCertificates.customize((SSLSession)sslSession, (EndPoint)endpoint, (Request)request);
        }
    }

    protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint) {
        return new ProtocolIdentifyingConnection((ProtocolIdentifyingEndpoint)endpoint);
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        ProtocolIdentifyingEndpoint endpoint = new ProtocolIdentifyingEndpoint(channel, selectSet, key, this.getMaxIdleTime());
        endpoint.setConnection((Connection)selectSet.getManager().newConnection(channel, (AsyncEndPoint)endpoint, key.attachment()));
        return endpoint;
    }

    protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
        SSLEngine engine;
        if (channel != null) {
            String peerHost = channel.socket().getInetAddress().getHostAddress();
            int peerPort = channel.socket().getPort();
            engine = this._sslContextFactory.newSslEngine(peerHost, peerPort);
        } else {
            engine = this._sslContextFactory.newSslEngine();
        }
        engine.setUseClientMode(false);
        return engine;
    }

    protected void doStart() throws Exception {
        this._sslContextFactory.checkKeyStore();
        this._sslContextFactory.start();
        SSLEngine sslEngine = this._sslContextFactory.newSslEngine();
        sslEngine.setUseClientMode(false);
        SSLSession sslSession = sslEngine.getSession();
        if (this.getRequestHeaderSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestHeaderSize(sslSession.getApplicationBufferSize());
        }
        if (this.getRequestBufferSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestBufferSize(sslSession.getApplicationBufferSize());
        }
        super.doStart();
    }

    public boolean isConfidential(Request request) {
        if (request.getScheme().equals("https")) {
            int confidentialPort = this.getConfidentialPort();
            return confidentialPort == 0 || confidentialPort == request.getServerPort();
        }
        return super.isConfidential(request);
    }

    private class ProtocolIdentifyingConnection
    implements AsyncConnection {
        private final ProtocolIdentifyingEndpoint _endpoint;
        private AsyncConnection _delegate;
        private final long _timestamp;
        private IOException _exception;

        private ProtocolIdentifyingConnection(ProtocolIdentifyingEndpoint endpoint) {
            this._endpoint = endpoint;
            this._timestamp = System.currentTimeMillis();
        }

        public void onInputShutdown() throws IOException {
            if (this._delegate == null) {
                this.createDelegate(true);
            }
            this._delegate.onInputShutdown();
        }

        private boolean createDelegate(boolean createPlainWhenUnknown) throws IOException {
            if (this._exception != null) {
                throw this._exception;
            }
            Protocol protocol = this._endpoint.getProtocol();
            if (protocol == Protocol.TCP || createPlainWhenUnknown && protocol == Protocol.UNKNOWN) {
                this._delegate = new AsyncHttpConnection((Connector)TcpAndSslSelectChannelConnector.this, (EndPoint)this._endpoint, TcpAndSslSelectChannelConnector.this.getServer());
                return true;
            }
            if (protocol == Protocol.SSL) {
                SocketChannel channel = this._endpoint.getSocketChannel();
                SSLEngine engine = TcpAndSslSelectChannelConnector.this.createSSLEngine(channel);
                SslConnection connection = new SslConnection(engine, (EndPoint)this._endpoint);
                AsyncHttpConnection delegate = new AsyncHttpConnection((Connector)TcpAndSslSelectChannelConnector.this, (EndPoint)connection.getSslEndPoint(), TcpAndSslSelectChannelConnector.this.getServer());
                connection.getSslEndPoint().setConnection((Connection)delegate);
                connection.setAllowRenegotiate(TcpAndSslSelectChannelConnector.this._sslContextFactory.isAllowRenegotiate());
                this._delegate = connection;
                return true;
            }
            return false;
        }

        private boolean createDelegateNoException() {
            try {
                return this.createDelegate(false);
            }
            catch (IOException e) {
                this._exception = e;
                return false;
            }
        }

        public Connection handle() throws IOException {
            if (this._delegate != null || this.createDelegate(false)) {
                return this._delegate.handle();
            }
            return this;
        }

        public long getTimeStamp() {
            return this._timestamp;
        }

        public boolean isIdle() {
            if (this._delegate != null || this.createDelegateNoException()) {
                return this._delegate.isIdle();
            }
            return false;
        }

        public boolean isSuspended() {
            if (this._delegate != null || this.createDelegateNoException()) {
                return this._delegate.isSuspended();
            }
            return false;
        }

        public void onClose() {
            if (this._delegate != null) {
                this._delegate.onClose();
            }
        }

        public void onIdleExpired(long idleForMs) {
            try {
                if (this._delegate != null || this.createDelegate(true)) {
                    this._delegate.onIdleExpired(idleForMs);
                }
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
                try {
                    this._endpoint.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
        }
    }

    private class ProtocolIdentifyingEndpoint
    extends SelectChannelEndPoint {
        private Protocol _protocol;
        private Buffer _preBuffer;

        public ProtocolIdentifyingEndpoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, int maxIdleTime) throws IOException {
            super(channel, selectSet, key, maxIdleTime);
            this._protocol = Protocol.UNKNOWN;
            this._preBuffer = new IndirectNIOBuffer(6);
        }

        public Protocol getProtocol() throws IOException {
            if (this._protocol == Protocol.UNKNOWN && this._preBuffer.space() != 0) {
                super.fill(this._preBuffer);
                this._protocol = this.identifyFromPreBuffer();
            }
            return this._protocol;
        }

        public SocketChannel getSocketChannel() {
            return (SocketChannel)this.getChannel();
        }

        private Protocol identifyFromPreBuffer() {
            if (this._preBuffer.space() == 0) {
                byte[] helloBytes = this._preBuffer.array();
                if (this.looksLikeSSLv2ClientHello(helloBytes) || this.looksLikeSSLv3ClientHello(helloBytes)) {
                    return Protocol.SSL;
                }
                return Protocol.TCP;
            }
            return Protocol.UNKNOWN;
        }

        private boolean looksLikeSSLv3ClientHello(byte[] headerBytes) {
            return headerBytes[0] == 22 && headerBytes[1] == 3 && (headerBytes[2] == 0 || headerBytes[2] == 1 || headerBytes[2] == 2 || headerBytes[2] == 3) && headerBytes[5] == 1;
        }

        private boolean looksLikeSSLv2ClientHello(byte[] headerBytes) {
            return headerBytes[0] == -128 && headerBytes[3] == 3 && (headerBytes[4] == 0 || headerBytes[4] == 1 || headerBytes[4] == 2 || headerBytes[4] == 3);
        }

        public int fill(Buffer buffer) throws IOException {
            int size = 0;
            if (this.getProtocol() != Protocol.UNKNOWN) {
                if (this._preBuffer.hasContent()) {
                    size = buffer.put(this._preBuffer);
                    this._preBuffer.skip(size);
                }
                if (buffer.space() != 0) {
                    size += super.fill(buffer);
                }
            }
            return size;
        }
    }

    static enum Protocol {
        UNKNOWN,
        TCP,
        SSL;

    }
}

